/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.SchemaObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraTable
extends DbmTable {
    @NotNull
    private final OraSchema mySchema;
    @StateProperty
    public final SchemaObjectRef<OraObjectType> myRowObjectType;

    public OraTable(@NotNull OraSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraTable", "<init>"));
        }
        super(schema, name);
        this.mySchema = schema;
        this.myRowObjectType = new SchemaObjectRef(schema.getModel(), ObjectKind.OBJECT_TYPE);
        assert (name == null || !name.startsWith("BIN$"));
    }

    @Override
    protected void childBorn(@NotNull DbmObject child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/dbm/oracle/OraTable", "childBorn"));
        }
        super.childBorn(child);
        if (child instanceof DbmConstraint && child.hasName()) {
            this.mySchema.registerConstraint((DbmConstraint)child);
        }
    }

    @Override
    protected void childDied(@NotNull DbmObject child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/dbm/oracle/OraTable", "childDied"));
        }
        super.childBorn(child);
        String childName = child.getName();
        if (child instanceof DbmConstraint && childName != null) {
            this.mySchema.unregisterConstraint(childName);
        }
    }

    public void setRowObjectType(@Nullable String schemaName, @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/dbm/oracle/OraTable", "setRowObjectType"));
        }
        this.myRowObjectType.setObject(schemaName, typeName);
    }

    public void setRowObjectType(@Nullable OraObjectType rowObjectType) {
        this.myRowObjectType.setObject(rowObjectType);
    }

    @Nullable
    public OraObjectType getRowObjectType() {
        OraObjectType objectType = this.myRowObjectType.getObject();
        return objectType;
    }

    @Override
    @Nullable
    public DbmLikeColumn resolveColumn(@Nullable String name) {
        OraObjectType objectType;
        if (name == null) {
            return null;
        }
        DbmLikeColumn resolvedColumn = super.resolveColumn(name);
        if (resolvedColumn == null && (objectType = this.myRowObjectType.getObject()) != null) {
            resolvedColumn = objectType.attributes().get(name);
        }
        return resolvedColumn;
    }
}

