/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.oracle.OraColumn;
import com.intellij.dbm.oracle.OraSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraView
extends DbmView {
    private final Family<OraColumn> myColumns;
    private final Family<DbmTrigger> myTriggers;
    private final Family<DbmIndex> myIndices;
    private final Family<DbmKey> myKeys;
    private final Family<DbmForeignKey> myForeignKeys;
    private final Family<DbmCheck> myChecks;

    @Override
    @NotNull
    public Family<? extends DbmColumn> columns() {
        Family<OraColumn> family = this.myColumns;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "columns"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmTrigger> triggers() {
        Family<DbmTrigger> family = this.myTriggers;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "triggers"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmIndex> indices() {
        Family<DbmIndex> family = this.myIndices;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "indices"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmKey> keys() {
        Family<DbmKey> family = this.myKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "keys"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmForeignKey> foreignKeys() {
        Family<DbmForeignKey> family = this.myForeignKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "foreignKeys"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmCheck> checks() {
        Family<DbmCheck> family = this.myChecks;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraView", "checks"));
        }
        return family;
    }

    public OraView(@NotNull OraSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraView", "<init>"));
        }
        super(schema, name);
        this.myColumns = Family.of(this, ObjectKind.COLUMN);
        this.myTriggers = Family.of(this, ObjectKind.TRIGGER);
        this.myIndices = Family.of(this, ObjectKind.INDEX);
        this.myKeys = Family.of(this, ObjectKind.KEY);
        this.myForeignKeys = Family.of(this, ObjectKind.FOREIGN_KEY);
        this.myChecks = Family.of(this, ObjectKind.CHECK);
        this.assignFamilies(this.myColumns, this.myTriggers);
    }
}

