/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseFunction
extends DbmSingleRoutine {
    public SybaseFunction(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/sybase/SybaseFunction", "<init>"));
        }
        super(schema, name);
        this.myRoutineKind = DasRoutine.Kind.FUNCTION;
    }

    @Override
    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = DasRoutine.Kind.FUNCTION;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseFunction", "getRoutineKind"));
        }
        return kind;
    }

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
        if (routineKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/dbm/sybase/SybaseFunction", "setRoutineKind"));
        }
        if (routineKind != DasRoutine.Kind.FUNCTION) {
            throw new IllegalStateException("Sybase function cannot be " + routineKind.toString());
        }
    }

    @Override
    @NotNull
    public DbmArgument getOrCreateReturnArgument() {
        DbmArgument r = this.getReturnArgument();
        if (r == null) {
            this.modifying();
            r = this.arguments().create(null);
            r.setDirection(DasArgument.Direction.RETURN);
        } else {
            r.resetSyncPending();
        }
        DbmArgument dbmArgument = r;
        if (dbmArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseFunction", "getOrCreateReturnArgument"));
        }
        return dbmArgument;
    }
}

