/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.script.QueryParametersProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQueryParametersProvider
extends QueryParametersProvider<SqlFile> {
    @Nullable
    public Map<String, PsiElement> getParameters(@NotNull SqlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlQueryParametersProvider", "getParameters"));
        }
        SqlStatement statement = null;
        for (PsiElement element : file.getChildren()) {
            if (element instanceof SqlStatement) {
                if (statement == null) {
                    statement = (SqlStatement)element;
                    continue;
                }
                return null;
            }
            if (!(element instanceof SqlCompositeElementImpl)) continue;
            return null;
        }
        if (statement == null) {
            return null;
        }
        THashMap map = new THashMap();
        final SqlVisitor visitor = new SqlVisitor((Map)map, file){
            final /* synthetic */ Map val$map;
            final /* synthetic */ SqlFile val$file;
            {
                this.val$map = map;
                this.val$file = sqlFile;
            }

            public void visitSqlParameter(SqlParameter o) {
                String name = o.getName();
                String realName = StringUtil.isEmpty((String)name) ? String.valueOf(this.val$map.size() + 1) : name;
                this.val$map.put(realName, new Parameter(this.val$file, o));
            }
        };
        statement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof SqlElement) {
                    ((SqlElement)element).accept(visitor);
                }
                super.visitElement(element);
            }
        });
        return map;
    }

    public static class Parameter
    extends RenameableFakePsiElement {
        private final SqlFile myContainingFile;
        private final SqlParameter myUsage;

        public Parameter(SqlFile containingFile, SqlParameter usage) {
            super((PsiElement)containingFile);
            this.myContainingFile = containingFile;
            this.myUsage = usage;
        }

        public String getName() {
            return this.myUsage.getName();
        }

        @Nullable
        public TextRange getTextRange() {
            return this.myUsage.getTextRange();
        }

        public PsiElement getNavigationElement() {
            return this.myUsage;
        }

        public PsiElement getParent() {
            return this.getContainingFile();
        }

        public String getTypeName() {
            return "Query Parameter";
        }

        @Nullable
        public Icon getIcon() {
            return PlatformIcons.PARAMETER_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Parameter that = (Parameter)((Object)o);
            return this.myUsage.equals(that.myUsage);
        }

        public int hashCode() {
            return this.myUsage.hashCode();
        }

        public boolean isValid() {
            if (!super.isValid()) {
                return false;
            }
            Map<String, PsiElement> params = new SqlQueryParametersProvider().getParameters(this.myContainingFile);
            return params != null && params.containsValue((Object)this);
        }
    }
}

