/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTypeElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlPostgresqlSelectFromProcedureInspection
extends SqlInspectionBase {
    private static boolean needTypedAliasDefinition(@NotNull SqlFunctionCallExpression functionCall) {
        String sqlType;
        if (functionCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCall", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection", "needTypedAliasDefinition"));
        }
        SqlReferenceExpression nameElement = functionCall.getNameElement();
        if (nameElement == null) {
            return false;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)nameElement.getName(), (CharSequence)"dblink")) {
            return true;
        }
        PsiElement resolve = nameElement.resolve();
        if (!(resolve instanceof DasRoutine)) {
            return false;
        }
        DasRoutine routine = (DasRoutine)resolve;
        for (DasArgument info : DasUtil.getParameters((DasRoutine)routine)) {
            DasArgument.Direction type = info.getArgumentDirection();
            if (type != DasArgument.Direction.OUT && type != DasArgument.Direction.INOUT) continue;
            return false;
        }
        DasArgument retArg = routine.getReturnArgument();
        DataType type = retArg == null ? null : retArg.getDataType();
        String string = sqlType = type != null ? type.getSpecification() : null;
        return StringUtil.equalsIgnoreCase((CharSequence)"record", (CharSequence)sqlType);
    }

    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection", "createAnnotationVisitor"));
        }
        if (!dialect.getDatabaseDialect().getFamilyId().isPostgres()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlAsExpression(SqlAsExpression o) {
                this.processExpression(o.getExpression(), o.getColumnAliasList());
            }

            public void visitSqlFromClause(SqlFromClause o) {
                super.visitSqlFromClause(o);
                SqlExpression expression = o.getFromExpression();
                this.processExpression(expression, Collections.emptyList());
            }

            private void processExpression(SqlExpression expression, List<SqlColumnAliasDefinition> aliases) {
                SqlFunctionCallExpression function;
                if (expression instanceof SqlFunctionCallExpression) {
                    this.processFunctionCall((SqlFunctionCallExpression)expression, aliases);
                } else if (expression instanceof SqlExplicitTableExpression && (function = (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlFunctionCallExpression.class)) != null) {
                    this.processFunctionCall(function, aliases);
                }
            }

            private void processFunctionCall(SqlFunctionCallExpression functionCall, List<SqlColumnAliasDefinition> aliases) {
                boolean needTypedAliasDefinition = SqlPostgresqlSelectFromProcedureInspection.needTypedAliasDefinition(functionCall);
                if (needTypedAliasDefinition && aliases.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)functionCall, "The function call must have a typed alias definition", (LocalQuickFix)((LocalQuickFixBase)null), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    return;
                }
                for (SqlDefinition sqlDefinition : aliases) {
                    if (sqlDefinition.getKind() != ObjectKind.COLUMN) continue;
                    SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)sqlDefinition, SqlTypeElement.class);
                    if (needTypedAliasDefinition && type == null) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)sqlDefinition, "The alias must have a type", (LocalQuickFix)new MyAddTypeQuickFix("Add type element", "SQL"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                    }
                    if (needTypedAliasDefinition || type == null) continue;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)sqlDefinition, "The alias can not have a type", (LocalQuickFix)new MyRemoveTypeQuickFix("Remove type element", "SQL"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }
        };
    }

    private static class MyAddTypeQuickFix
    extends LocalQuickFixBase {
        protected MyAddTypeQuickFix(@NotNull String name, @NotNull String familyName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyAddTypeQuickFix", "<init>"));
            }
            if (familyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyAddTypeQuickFix", "<init>"));
            }
            super(name, familyName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyAddTypeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyAddTypeQuickFix", "applyFix"));
            }
            PsiElement alias = descriptor.getPsiElement();
            if (alias instanceof SqlDefinition) {
                SqlNameElement name = ((SqlDefinition)alias).getNameElement();
                PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
                PsiFile file = alias.getContainingFile();
                Document document = instance.getDocument(file);
                if (name != null && document != null) {
                    int offset = name.getTextRange().getEndOffset();
                    String defaultType = "int";
                    document.insertString(offset, (CharSequence)(" " + defaultType));
                    instance.commitDocument(document);
                    Editor editor = PsiUtilBase.findEditor((PsiElement)file);
                    if (editor != null) {
                        int startOffset = offset + 1;
                        editor.getCaretModel().moveToOffset(startOffset);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().setSelection(startOffset, startOffset + defaultType.length());
                    }
                }
            }
        }
    }

    private static class MyRemoveTypeQuickFix
    extends LocalQuickFixBase {
        protected MyRemoveTypeQuickFix(@NotNull String name, @NotNull String familyName) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyRemoveTypeQuickFix", "<init>"));
            }
            if (familyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyRemoveTypeQuickFix", "<init>"));
            }
            super(name, familyName);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            SqlTypeElement type;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyRemoveTypeQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/dialects/postgres/inspections/SqlPostgresqlSelectFromProcedureInspection$MyRemoveTypeQuickFix", "applyFix"));
            }
            PsiElement alias = descriptor.getPsiElement();
            if (alias instanceof SqlDefinition && (type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)alias, SqlTypeElement.class)) != null) {
                type.delete();
            }
        }
    }
}

