/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresParser;
import com.intellij.sql.dialects.postgres.psi.FunctionBodyInjector;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgCodeBlockElementType
extends SqlLazyElementType {
    protected PgCodeBlockElementType(@NotNull @NonNls String debugName, PostgresDialect dialect) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/dialects/postgres/psi/PgCodeBlockElementType", "<init>"));
        }
        super(debugName, (SqlLanguageDialect)dialect);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/sql/dialects/postgres/psi/PgCodeBlockElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/dialects/postgres/psi/PgCodeBlockElementType", "doParseContents"));
        }
        return this.parseLight(chameleon).getTreeBuilt().getFirstChildNode();
    }

    private static Language calcInnerChameleonLanguage(PsiBuilder builder) {
        String langSpec = null;
        boolean grabNextToken = false;
        IElementType t = builder.rawLookup(0);
        int i = 0;
        while (t != null) {
            if (grabNextToken && !GeneratedParserUtilBase.isWhitespaceOrComment((PsiBuilder)builder, (IElementType)t)) {
                langSpec = PsiBuilderUtil.rawTokenText((PsiBuilder)builder, (int)i).toString();
                break;
            }
            if (t == PgTypes.PG_LANGUAGE) {
                grabNextToken = true;
            }
            t = builder.rawLookup(++i);
        }
        return FunctionBodyInjector.getBlockByLangSpec(langSpec, null);
    }

    public static class BodyElement
    extends LazyParseablePsiElement {
        BodyElement(PgCodeBlockElementType type, CharSequence text) {
            super((IElementType)type, text);
        }
    }

    public static class CodeBlock
    extends PgCodeBlockElementType {
        public CodeBlock(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/dialects/postgres/psi/PgCodeBlockElementType$CodeBlock", "<init>"));
            }
            super(debugName, PostgresDialect.PlDialect.INSTANCE);
        }

        @Nullable
        public ASTNode createNode(CharSequence text) {
            return new BodyElement(this, text);
        }

        public PsiBuilder parseLight(ASTNode chameleon) {
            LANGUAGE_KEY.set((UserDataHolder)chameleon, (Object)PostgresDialect.PlDialect.INSTANCE);
            return PostgresElementTypes.PG_PL_SQL_FILE.parseLight(chameleon);
        }
    }

    public static class Parent
    extends PgCodeBlockElementType {
        public Parent(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/dialects/postgres/psi/PgCodeBlockElementType$Parent", "<init>"));
            }
            super(debugName, PostgresDialect.INSTANCE);
        }

        @Nullable
        public ASTNode createNode(CharSequence text) {
            return new LazyParseablePsiElement((IElementType)this, text);
        }

        public PsiBuilder parseLight(ASTNode chameleon) {
            PsiElement psi = chameleon.getTreeParent().getPsi();
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)psi);
            PostgresDialect language = PostgresDialect.INSTANCE;
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
            Project project = psi.getProject();
            Lexer lexer = SqlPreprocessingLexer.withPreprocessingIfNeeded(project, parserDefinition, (PsiElement)host);
            PostgresParser parser = (PostgresParser)parserDefinition.createParser(project);
            PsiBuilder initialBuilder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, (Language)language, chameleon.getChars());
            PsiBuilder builder = parser.adaptBuilder((IElementType)parserDefinition.getFileNodeType(), initialBuilder);
            PsiBuilder.Marker m = builder.mark();
            Language value = (Language)ObjectUtils.notNull((Object)PgCodeBlockElementType.calcInnerChameleonLanguage(builder), (Object)PlainTextLanguage.INSTANCE);
            LANGUAGE_KEY.set((UserDataHolder)builder, (Object)value);
            GeneratedParserUtilBase.Parser p = (GeneratedParserUtilBase.Parser)ObjectUtils.tryCast((Object)SqlInfoElementType.getValue(chameleon.getTreePrev()), GeneratedParserUtilBase.Parser.class);
            if (p != null) {
                p.parse(builder, 1);
            }
            m.done((IElementType)this);
            if (!builder.eof()) {
                throw new AssertionError((Object)String.valueOf(p));
            }
            return builder;
        }
    }
}

