/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.BraceMatcherBasedSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import java.util.List;

public class SqlBraceMatcherBasedSelectioner
extends BraceMatcherBasedSelectioner {
    public boolean canSelect(PsiElement e) {
        return e instanceof SqlElement;
    }

    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof SqlStatement || e instanceof SqlBatchBlock) {
            ASTNode eNode;
            result.addAll(SqlBraceMatcherBasedSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)e.getTextRange()));
            SqlLanguageDialect dialect = SqlLanguageSubstitutor.getSqlLanguageDialect(e.getContainingFile().getVirtualFile(), e.getProject());
            TokenSet closingTokens = dialect != null ? dialect.getStatementSeparators() : SqlTokens.STATEMENT_SEPARATORS;
            for (ASTNode node = eNode = e.getNode(); node != null; node = node.getTreeNext()) {
                if (!closingTokens.contains(node.getElementType())) continue;
                TextRange range = new TextRange(eNode.getStartOffset(), node.getStartOffset() + node.getTextLength());
                result.add(range);
                result.addAll(SqlBraceMatcherBasedSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)range));
                break;
            }
        } else if (e instanceof SqlStringTokenElement) {
            SqlStringTokenElement element = (SqlStringTokenElement)e;
            result.add(element.getRangeInElement().shiftRight(element.getStartOffset()));
        }
        return result;
    }
}

