/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class SqlParameterImpl
extends SqlExpressionImpl
implements SqlParameter {
    public SqlParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlParameterImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        SqlNameElement nameElement = this.getNameElement();
        if (nameElement != null) {
            SqlNameElement sqlNameElement = nameElement;
            if (sqlNameElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getNavigationElement"));
            }
            return sqlNameElement;
        }
        PsiElement intToken = this.findChildByType((IElementType)SqlTokens.SQL_INTEGER_TOKEN);
        if (intToken != null) {
            PsiElement psiElement = intToken;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getNavigationElement"));
            }
            return psiElement;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getNavigationElement"));
        }
        return psiElement;
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlParameter((SqlParameter)this);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }

    public SqlNameElement getNameElement() {
        return (SqlNameElement)this.findChildByClass(SqlNameElement.class);
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement child0 = this.getFirstChild();
        IElementType type0 = PsiUtilCore.getElementType((PsiElement)child0);
        if (type0 == SqlTokens.SQL_EXTERNAL_PARAM) {
            String string = child0.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getName"));
            }
            return string;
        }
        if (type0 == SqlTokens.SQL_CUSTOM_PARAM_LQUOTE || type0 == SqlTokens.SQL_EXTERNAL_PARAM_PREFIX) {
            String string = child0.getNextSibling().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getName"));
            }
            return string;
        }
        if (PsiUtilCore.getElementType((PsiElement)this.getLastChild()) == SqlTokens.SQL_INTEGER_TOKEN) {
            String string = this.getLastChild().getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getName"));
            }
            return string;
        }
        SqlNameElement id = this.getNameElement();
        if (id != null) {
            String string = id.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getName"));
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlParameterImpl", "getName"));
        }
        return string;
    }
}

