/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.configSlurper.ConfigSlurperSupport;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class AbstractConfigSupport
extends ConfigSlurperSupport
implements ConfigSlurperSupport.PropertiesProvider {
    private String[] myFinalProperties;
    private String[] myPrefixes;

    @NotNull
    protected abstract String[] getFinalProperties();

    @NotNull
    protected String[] getPrefixes() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/AbstractConfigSupport", "getPrefixes"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public abstract ConfigSlurperSupport.PropertiesProvider getProvider(@NotNull GroovyFile var1);

    public void collectVariants(@NotNull List<String> prefix, @NotNull PairConsumer<String, Boolean> consumer) {
        String suffix;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/plugins/grails/config/AbstractConfigSupport", "collectVariants"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/grails/config/AbstractConfigSupport", "collectVariants"));
        }
        String sPrefix = StringUtil.join(prefix, (String)".");
        int prefixLength = sPrefix.length();
        if (prefixLength > 0) {
            ++prefixLength;
        }
        if (this.myFinalProperties == null) {
            this.myFinalProperties = this.getFinalProperties();
        }
        for (String property : this.myFinalProperties) {
            if (!property.startsWith(sPrefix) || prefixLength >= property.length()) continue;
            suffix = property.substring(prefixLength);
            consumer.consume((Object)suffix, (Object)true);
        }
        if (this.myPrefixes == null) {
            this.myPrefixes = this.getPrefixes();
        }
        for (String property : this.myPrefixes) {
            if (!property.startsWith(sPrefix) || prefixLength >= property.length()) continue;
            suffix = property.substring(prefixLength);
            consumer.consume((Object)suffix, (Object)false);
        }
    }
}

