/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.ui.GrailsSDKHomeForm;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsProjectStructureDetector
extends ProjectStructureDetector {
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
        }
        if (GrailsProjectStructureDetector.hasFilename(children, "grails-app", false) && GrailsProjectStructureDetector.hasFilename(children, "application.properties", true) && new File(new File(new File(dir, "grails-app"), "conf"), "BuildConfig.groovy").exists()) {
            result.add(new GrailsDetectedProjectRoot(dir));
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ModuleWizardStep javaSdkStep = ProjectWizardStepFactory.getInstance().createProjectJdkStep(builder.getContext());
        GrailsSDKWizardStep groovySdkStep = new GrailsSDKWizardStep(builder, this);
        return Arrays.asList(new ModuleWizardStep[]{javaSdkStep, groovySdkStep});
    }

    private static boolean hasFilename(File[] children, String name, boolean isFile) {
        for (File child : children) {
            if (!(isFile ? child.isFile() : child.isDirectory()) || !child.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static class GrailsSDKWizardStep
    extends ModuleWizardStep {
        private final GrailsSDKHomeForm myForm = new GrailsSDKHomeForm().setVersionRange(Version.LESS_THAN_3);
        private final ProjectFromSourcesBuilder myFromSourcesBuilder;
        private final GrailsProjectStructureDetector myDetector;

        public GrailsSDKWizardStep(ProjectFromSourcesBuilder builder, GrailsProjectStructureDetector detector) {
            this.myForm.setPath(PropertiesComponent.getInstance().getValue("grails.last.selected.sdk.home"));
            this.myFromSourcesBuilder = builder;
            this.myDetector = detector;
        }

        public JComponent getComponent() {
            return this.myForm.getComponent();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myForm.getPathComponent();
        }

        public boolean validate() throws ConfigurationException {
            return this.myForm.validate();
        }

        public void updateDataModel() {
            List modules = this.myFromSourcesBuilder.getProjectRoots((ProjectStructureDetector)this.myDetector).stream().map(root -> {
                final File directory = root.getDirectory();
                ModuleDescriptor descriptor = new ModuleDescriptor(directory, StdModuleTypes.JAVA, Collections.emptyList());
                descriptor.addConfigurationUpdater(new ModuleBuilder.ModuleConfigurationUpdater(){

                    public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                        if (module == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsSDKWizardStep$1", "update"));
                        }
                        if (rootModel == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsSDKWizardStep$1", "update"));
                        }
                        GrailsSDKManager.getInstance(module.getProject()).setGrailsSDK(directory.getAbsolutePath(), myForm.getSelectedSdk().getPath());
                    }
                });
                return descriptor;
            }).collect(Collectors.toList());
            this.myFromSourcesBuilder.getProjectDescriptor((ProjectStructureDetector)this.myDetector).setModules(modules);
        }
    }

    private static class GrailsDetectedProjectRoot
    extends DetectedProjectRoot {
        protected GrailsDetectedProjectRoot(@NotNull File directory) {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsDetectedProjectRoot", "<init>"));
            }
            super(directory);
        }

        @NotNull
        public String getRootTypeName() {
            if ("Grails" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsDetectedProjectRoot", "getRootTypeName"));
            }
            return "Grails";
        }

        public boolean canContainRoot(@NotNull DetectedProjectRoot root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/config/GrailsProjectStructureDetector$GrailsDetectedProjectRoot", "canContainRoot"));
            }
            return GrailsDetectedProjectRoot.class.equals(root.getClass());
        }
    }
}

