/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.maven;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.plugins.grails.maven.GrailsMavenApplication;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class MavenCommandExecutor
extends GrailsCommandLineExecutor
implements GrailsRunConfigurationExtension<MavenGeneralSettings> {
    public static final Key<MavenGeneralSettings> DATA_KEY = Key.create((String)(MavenCommandExecutor.class.getName() + " data key"));
    private static final Map<String, String> ourCommandGoals = GrailsUtils.createMap("run-app", "grails:run-app", "test-app", "grails:test-app", "war", "grails:war");

    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication) {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "isApplicable"));
        }
        return grailsApplication instanceof GrailsMavenApplication;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication, @NotNull MvcCommand command, @Nullable MavenGeneralSettings generalSettings) throws ExecutionException {
        ParametersList vmOptionList;
        Version grailsVersion;
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        if (!(grailsApplication instanceof GrailsMavenApplication)) {
            throw new ExecutionException("Cannot execute " + grailsApplication.getClass());
        }
        Project project = grailsApplication.getProject();
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance((Project)project);
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance((Project)project).getSettings().clone();
        runnerSettings.setVmOptions(command.getVmOptions());
        String parameterStr = null;
        if (command.getArgs().size() > 0) {
            parameterStr = ParametersList.join((List)command.getArgs());
        }
        String goal = null;
        String mappedGoal = ourCommandGoals.get(command.getCommand());
        if ("test-app".equals(command.getCommand()) && (grailsVersion = grailsApplication.getVersion()).compareToString("2.1.0") < 0) {
            mappedGoal = null;
        }
        if (mappedGoal != null) {
            goal = mappedGoal;
            if (parameterStr != null) {
                vmOptionList = new ParametersList();
                vmOptionList.addParametersString(runnerSettings.getVmOptions());
                vmOptionList.addProperty("grails.cli.args", parameterStr);
                runnerSettings.setVmOptions(vmOptionList.getParametersString());
            }
        } else if (command.getCommand() != null) {
            goal = "grails:exec";
            runnerSettings.getMavenProperties().put("command", command.getCommand());
            if (parameterStr != null) {
                runnerSettings.getMavenProperties().put("args", parameterStr);
            }
        }
        if (command.getProperties().size() > 0 || command.getEnv() != null) {
            vmOptionList = new ParametersList();
            vmOptionList.addParametersString(runnerSettings.getVmOptions());
            vmOptionList.addAll((List)command.getProperties());
            if (command.getEnv() != null) {
                vmOptionList.add("-Dgrails.env=" + command.getEnv());
            }
            runnerSettings.setVmOptions(vmOptionList.getParametersString());
        }
        MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
        MavenRunnerParameters runnerParameters = new MavenRunnerParameters(true, grailsApplication.getRoot().getPath(), goal == null ? Collections.emptyList() : Collections.singletonList(goal), explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
        JavaParameters res = MavenExternalParameters.createJavaParameters((Project)project, (MavenRunnerParameters)runnerParameters, (MavenGeneralSettings)generalSettings, (MavenRunnerSettings)runnerSettings, null);
        GrailsExecutionUtils.addCommonJvmOptions(res);
        JavaParameters javaParameters = res;
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication, @NotNull MvcCommand command) throws ExecutionException {
        if (grailsApplication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplication", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        JavaParameters javaParameters = this.createJavaParameters(grailsApplication, command, null);
        if (javaParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createJavaParameters"));
        }
        return javaParameters;
    }

    @Override
    public void addListener(@NotNull JavaParameters params, @NotNull String listener) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "addListener"));
        }
        super.addListener(params, listener);
        GrailsExecutionUtils.addAgentJar(params);
    }

    @Override
    @NotNull
    public Key<MavenGeneralSettings> getKey() {
        Key<MavenGeneralSettings> key = DATA_KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "getKey"));
        }
        return key;
    }

    @Override
    @Nullable
    public Pair<String, SettingsEditor<GrailsRunConfiguration>> createSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "createSettingsEditor"));
        }
        return new Pair((Object)"Maven Settings", (Object)new GrailsMavenSettingsEditor(project));
    }

    @Override
    @Nullable
    public MavenGeneralSettings readAdditionalConfiguration(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "readAdditionalConfiguration"));
        }
        Element e = element.getChild(MavenGeneralSettings.class.getSimpleName());
        return e != null ? (MavenGeneralSettings)XmlSerializer.deserialize((Element)e, MavenGeneralSettings.class) : null;
    }

    @Override
    public void writeAdditionalConfiguration(@NotNull MavenGeneralSettings cfg, @NotNull Element element) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "writeAdditionalConfiguration"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor", "writeAdditionalConfiguration"));
        }
        element.addContent(XmlSerializer.serialize((Object)cfg));
    }

    public static class GrailsMavenSettingsEditor
    extends SettingsEditor<GrailsRunConfiguration> {
        private final MavenGeneralSettingsEditor myDelegate;

        private GrailsMavenSettingsEditor(Project project) {
            this.myDelegate = new MavenGeneralSettingsEditor(project);
            Disposer.register((Disposable)this, (Disposable)this.myDelegate);
        }

        protected void resetEditorFrom(GrailsRunConfiguration s2) {
            this.myDelegate.resetFrom((Object)GrailsMavenSettingsEditor.getConfiguration(s2));
        }

        protected void applyEditorTo(GrailsRunConfiguration s2) throws ConfigurationException {
            MavenRunConfiguration mavenRunConfiguration = GrailsMavenSettingsEditor.getConfiguration(s2);
            this.myDelegate.applyTo((Object)mavenRunConfiguration);
            s2.putUserData(DATA_KEY, mavenRunConfiguration.getGeneralSettings());
        }

        @NotNull
        protected JComponent createEditor() {
            JComponent jComponent = this.myDelegate.getComponent();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor$GrailsMavenSettingsEditor", "createEditor"));
            }
            return jComponent;
        }

        @NotNull
        private static MavenRunConfiguration getConfiguration(GrailsRunConfiguration s2) {
            ConfigurationFactory factory = MavenRunConfigurationType.getInstance().getConfigurationFactories()[0];
            MavenRunConfiguration mavenRunConfiguration = (MavenRunConfiguration)factory.createTemplateConfiguration(s2.getProject());
            mavenRunConfiguration.setGeneralSettings((MavenGeneralSettings)s2.getUserData(DATA_KEY));
            MavenRunConfiguration mavenRunConfiguration2 = mavenRunConfiguration;
            if (mavenRunConfiguration2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/maven/MavenCommandExecutor$GrailsMavenSettingsEditor", "getConfiguration"));
            }
            return mavenRunConfiguration2;
        }
    }
}

