/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain.detachedCriteria;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class DetachedCriteriaUtil {
    public static final String DETACHED_CRITERIA_CLASS = "grails.gorm.DetachedCriteria";

    private DetachedCriteriaUtil() {
    }

    public static boolean isDomainDetachedCriteriaMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/grails/references/domain/detachedCriteria/DetachedCriteriaUtil", "isDomainDetachedCriteriaMethod"));
        }
        if (GrLightMethodBuilder.checkKind((PsiElement)method, (Object)DomainDescriptor.DOMAIN_DYNAMIC_METHOD)) {
            String methodName = method.getName();
            return "where".equals(methodName) || "findAll".equals(methodName) || "find".equals(methodName);
        }
        return false;
    }

    @Nullable
    public static PsiClass getDomainFromSubstitutor(@NotNull GroovyResolveResult resolveResult) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "org/jetbrains/plugins/grails/references/domain/detachedCriteria/DetachedCriteriaUtil", "getDomainFromSubstitutor"));
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (substitutor == null) {
            return null;
        }
        Map substitutionMap = substitutor.getSubstitutionMap();
        if (substitutionMap.size() != 1) {
            return null;
        }
        PsiClass res = PsiTypesUtil.getPsiClass((PsiType)((PsiType)substitutionMap.values().iterator().next()));
        return GrailsArtifact.DOMAIN.isInstance(res) ? res : null;
    }

    @Nullable
    public static PsiClass getDomainClassByDetachedCriteriaExpression(@Nullable PsiType type) {
        if (!(type instanceof PsiImmediateClassType)) {
            return null;
        }
        PsiClass detachedCriteriaClass = PsiTypesUtil.getPsiClass((PsiType)type);
        if (detachedCriteriaClass == null || !DETACHED_CRITERIA_CLASS.equals(detachedCriteriaClass.getQualifiedName())) {
            return null;
        }
        PsiType[] parameters = ((PsiImmediateClassType)type).getParameters();
        if (parameters.length != 1) {
            return null;
        }
        PsiClass domainClass = PsiTypesUtil.getPsiClass((PsiType)parameters[0]);
        if (!GrailsArtifact.DOMAIN.isInstance(domainClass)) {
            return null;
        }
        return domainClass;
    }
}

