/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.util;

import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyTargetElementEvaluator;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class CodecUtil {
    private static final Map<String, Couple<Object>> standardCodecsTypeHint = new HashMap<String, Couple<Object>>();

    private CodecUtil() {
    }

    public static Map<String, Couple<PsiMethod>> getCodecMap(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/util/CodecUtil", "getCodecMap"));
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/util/CodecUtil", "lambda$getCodecMap$0"));
            }
            return CachedValueProvider.Result.create(CodecUtil.calculateCodecsMap(module), (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance((Project)module.getProject()).getFileAndRootsModificationTracker()});
        });
    }

    private static Map<String, Couple<PsiMethod>> calculateCodecsMap(Module module) {
        HashMap<String, Couple<PsiMethod>> res = new HashMap<String, Couple<PsiMethod>>();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("org.codehaus.groovy.grails.plugins.codecs");
        if (aPackage != null) {
            CodecUtil.parseCodecs(res, Arrays.asList(aPackage.getClasses(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false))));
            CodecUtil.parseCodecs(res, GrailsArtifact.CODEC.getInstances(module).values());
        }
        return res;
    }

    private static void parseCodecs(Map<String, Couple<PsiMethod>> result, Collection<? extends PsiClass> codecClasses) {
        for (PsiClass psiClass : codecClasses) {
            String name = psiClass.getName();
            if (!name.endsWith("Codec")) continue;
            String codecName = name.substring(0, name.length() - "Codec".length());
            PsiMethod encodeMethod = CodecUtil.createMethod(psiClass, true, codecName);
            PsiMethod decodeMethod = CodecUtil.createMethod(psiClass, false, codecName);
            result.put(codecName, (Couple<PsiMethod>)Couple.of((Object)encodeMethod, (Object)decodeMethod));
        }
    }

    @Nullable
    private static PsiMethod createMethod(final PsiClass codecClass, boolean isEncode, String codecName) {
        PsiField navigationElement;
        Object returnType;
        String methodName;
        block11: {
            String elementName;
            block10: {
                GrExpression initializer;
                PsiField field;
                if (isEncode) {
                    elementName = "encode";
                    methodName = "encodeAs" + codecName;
                } else {
                    elementName = "decode";
                    methodName = "decode" + codecName;
                }
                returnType = null;
                navigationElement = null;
                Couple<Object> pair = standardCodecsTypeHint.get(codecName);
                if (pair != null) {
                    Object obj;
                    Object object = obj = isEncode ? pair.first : pair.second;
                    if (obj == null) {
                        return null;
                    }
                    if (obj instanceof PsiType) {
                        returnType = new Computable.PredefinedValueComputable((Object)((PsiType)obj));
                    } else {
                        PsiClassType type = JavaPsiFacade.getElementFactory((Project)codecClass.getProject()).createTypeByFQClassName((String)obj, codecClass.getResolveScope());
                        returnType = new Computable.PredefinedValueComputable((Object)type);
                    }
                }
                if ((field = codecClass.findFieldByName(elementName, false)) == null || !field.hasModifierProperty("static")) break block10;
                navigationElement = field;
                if (returnType != null) break block11;
                if (field instanceof GrField && (initializer = ((GrField)field).getInitializerGroovy()) instanceof GrClosableBlock) {
                    returnType = new Computable.NotNullCachedComputable<PsiType>(){

                        @NotNull
                        protected PsiType internalCompute() {
                            PsiType returnType = ((GrClosableBlock)initializer).getReturnType();
                            if (returnType != null) {
                                PsiType psiType = returnType;
                                if (psiType == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/util/CodecUtil$1", "internalCompute"));
                                }
                                return psiType;
                            }
                            PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)codecClass.getManager(), (GlobalSearchScope)codecClass.getResolveScope());
                            if (psiClassType == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/util/CodecUtil$1", "internalCompute"));
                            }
                            return psiClassType;
                        }
                    };
                }
                if (returnType == null) {
                    returnType = new Computable.PredefinedValueComputable((Object)PsiType.getJavaLangObject((PsiManager)codecClass.getManager(), (GlobalSearchScope)codecClass.getResolveScope()));
                }
                break block11;
            }
            for (GrExpression psiMethod : codecClass.findMethodsByName(elementName, false)) {
                if (!psiMethod.hasModifierProperty("static") || psiMethod.getParameterList().getParametersCount() != 1) continue;
                navigationElement = psiMethod;
                if (returnType != null) break;
                returnType = new Computable.NotNullCachedComputable<PsiType>((PsiMethod)psiMethod, codecClass){
                    final /* synthetic */ PsiMethod val$psiMethod;
                    final /* synthetic */ PsiClass val$codecClass;
                    {
                        this.val$psiMethod = psiMethod;
                        this.val$codecClass = psiClass;
                    }

                    @NotNull
                    protected PsiType internalCompute() {
                        PsiType res = this.val$psiMethod instanceof GrMethod ? ((GrMethod)this.val$psiMethod).getInferredReturnType() : this.val$psiMethod.getReturnType();
                        if (res == null) {
                            PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)this.val$codecClass.getManager(), (GlobalSearchScope)this.val$codecClass.getResolveScope());
                            if (psiClassType == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/util/CodecUtil$2", "internalCompute"));
                            }
                            return psiClassType;
                        }
                        PsiType psiType = res;
                        if (psiType == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/util/CodecUtil$2", "internalCompute"));
                        }
                        return psiType;
                    }
                };
                break;
            }
        }
        if (navigationElement != null) {
            LightMethodBuilder res = new LightMethodBuilder(codecClass.getManager(), (Language)GroovyLanguage.INSTANCE, methodName);
            res.putUserData(GroovyTargetElementEvaluator.NAVIGATION_ELEMENT_IS_NOT_TARGET, (Object)Boolean.TRUE);
            res.setMethodReturnType((Computable)returnType);
            res.setContainingClass(codecClass);
            res.setModifiers(new String[]{"public"});
            res.setNavigationElement((PsiElement)navigationElement);
            return res;
        }
        return null;
    }

    static {
        PsiArrayType byteArray = PsiType.BYTE.createArrayType();
        standardCodecsTypeHint.put("Base64", (Couple<Object>)Couple.of((Object)"java.lang.String", (Object)byteArray));
        standardCodecsTypeHint.put("Hex", (Couple<Object>)Couple.of((Object)"java.lang.String", (Object)byteArray));
        standardCodecsTypeHint.put("HTML", (Couple<Object>)Couple.of((Object)"java.lang.String", (Object)"java.lang.String"));
        standardCodecsTypeHint.put("JavaScript", (Couple<Object>)Couple.of((Object)"java.lang.String", null));
        standardCodecsTypeHint.put("MD5Bytes", (Couple<Object>)Couple.of((Object)byteArray, null));
        standardCodecsTypeHint.put("MD5", (Couple<Object>)Couple.of((Object)"java.lang.String", null));
        standardCodecsTypeHint.put("SHA1Bytes", (Couple<Object>)Couple.of((Object)byteArray, null));
        standardCodecsTypeHint.put("SHA1", (Couple<Object>)Couple.of((Object)"java.lang.String", null));
        standardCodecsTypeHint.put("SHA256Bytes", (Couple<Object>)Couple.of((Object)byteArray, null));
        standardCodecsTypeHint.put("SHA256", (Couple<Object>)Couple.of((Object)"java.lang.String", null));
        standardCodecsTypeHint.put("URL", (Couple<Object>)Couple.of((Object)"java.lang.String", (Object)"java.lang.String"));
    }
}

