/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public abstract class GrailsCommandExecutor {
    public static final ExtensionPointName<GrailsCommandExecutor> EP_NAME = ExtensionPointName.create((String)"org.intellij.grails.commandExecutor");

    @Nullable
    @Contract(value="null -> null")
    public static GrailsCommandExecutor getGrailsExecutor(@Nullable GrailsApplication grailsApplication) {
        if (grailsApplication == null) {
            return null;
        }
        for (GrailsCommandExecutor executor : (GrailsCommandExecutor[])EP_NAME.getExtensions()) {
            if (!executor.isApplicable(grailsApplication)) continue;
            return executor;
        }
        return null;
    }

    public abstract boolean isApplicable(@NotNull GrailsApplication var1);

    @Nullable
    public abstract RunProfileState getState(@NotNull GrailsRunConfiguration var1, @NotNull Executor var2, @NotNull ExecutionEnvironment var3) throws ExecutionException;

    @Nullable
    public abstract ConsoleProcessDescriptor execute(@NotNull GrailsApplication var1, @NotNull MvcCommand var2, @Nullable Runnable var3, boolean var4, String ... var5) throws ExecutionException;
}

