/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.spring.GrailsCustomSpringComponent;
import org.jetbrains.plugins.grails.spring.GrailsResourceBeanExtractor;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsSpringBeanDiscoverer
extends CustomModuleComponentsDiscoverer {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"GrailsSpringBeanDiscoverer");
    private static final MultiMap<String, Couple<String>> PLUGINS_BEAN_MAP = new MultiMap();
    private static final Couple<String>[] COMMON_BEANS = new Couple[]{Couple.of((Object)"messageSource", (Object)"org.codehaus.groovy.grails.context.support.PluginAwareResourceBundleMessageSource"), Couple.of((Object)"grailsUrlMappingsHolder", (Object)"org.codehaus.groovy.grails.web.mapping.UrlMappingsHolderFactoryBean")};
    private static final Trinity<String, String, String>[] BEANS_BY_GRAILS_VERSION = new Trinity[]{Trinity.create((Object)"2.0.0", (Object)"grailsLinkGenerator", (Object)"org.codehaus.groovy.grails.web.mapping.LinkGenerator"), Trinity.create((Object)"2.0.0", (Object)"groovyPageRenderer", (Object)"grails.gsp.PageRenderer")};

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@Nullable Module module) {
        if (module == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "getCustomComponents"));
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(this.evaluateCustomComponents(module), this.getDependencies(module)));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "getCustomComponents"));
        }
        return collection;
    }

    @NotNull
    public Collection<CommonSpringBean> evaluateCustomComponents(Module module) {
        GrailsFramework grailsFramework = GrailsFramework.getInstance();
        if (grailsFramework.isCommonPluginsModule(module)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "evaluateCustomComponents"));
            }
            return list;
        }
        ArrayList<CommonSpringBean> result = new ArrayList<CommonSpringBean>();
        GrailsStructure structure = GrailsStructure.getInstance(module);
        if (structure == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "evaluateCustomComponents"));
            }
            return list;
        }
        for (GrClassDefinition classDefinition : GrailsArtifact.SERVICE.getInstances(module).values()) {
            result.add((CommonSpringBean)new CustomSpringComponent((PsiClass)classDefinition));
        }
        THashSet existBeans = new THashSet();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        GroovyPsiManager manager = GroovyPsiManager.getInstance((Project)module.getProject());
        for (Couple<String> couple : COMMON_BEANS) {
            GrailsSpringBeanDiscoverer.addBeanIfClassExists(result, (Set<String>)existBeans, manager, scope, (String)couple.first, (String)couple.second);
        }
        for (String pluginName : structure.getInstalledCommonPlugins().keySet()) {
            for (Couple couple : PLUGINS_BEAN_MAP.get((Object)pluginName)) {
                GrailsSpringBeanDiscoverer.addBeanIfClassExists(result, (Set<String>)existBeans, manager, scope, (String)couple.first, (String)couple.second);
            }
        }
        for (Trinity<String, String, String> trinity : BEANS_BY_GRAILS_VERSION) {
            if (!structure.isAtLeastGrails((String)trinity.first)) continue;
            GrailsSpringBeanDiscoverer.addBeanIfClassExists(result, (Set<String>)existBeans, manager, scope, (String)trinity.second, (String)trinity.third);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        GrailsSpringBeanDiscoverer.addBeanFromResourceGroovy(result, (Set<String>)existBeans, psiManager, structure.getAppRoot());
        Module commonPluginsModule = grailsFramework.findCommonPluginsModule(module);
        if (commonPluginsModule != null) {
            block5: for (VirtualFile root : ModuleRootManager.getInstance((Module)commonPluginsModule).getContentRoots()) {
                GrailsSpringBeanDiscoverer.addBeanFromResourceGroovy(result, (Set<String>)existBeans, psiManager, root);
                for (VirtualFile file : root.getChildren()) {
                    GrTypeDefinition pluginClass;
                    if (!file.getName().endsWith("GrailsPlugin.groovy") || (pluginClass = GroovyUtils.getPublicClass((VirtualFile)file, (PsiManager)psiManager)) == null) continue;
                    List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromPluginClass(pluginClass);
                    GrailsSpringBeanDiscoverer.convertBeans(result, (Set<String>)existBeans, descriptors);
                    continue block5;
                }
            }
        } else {
            AllClassesSearch.search((SearchScope)scope, (Project)module.getProject(), name -> name.endsWith("GrailsPlugin")).forEach(clazz -> {
                if (!(clazz instanceof GrTypeDefinition)) {
                    clazz = clazz.getNavigationElement();
                }
                if (!(clazz instanceof GrTypeDefinition)) {
                    return;
                }
                List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromPluginClass((GrTypeDefinition)clazz);
                GrailsSpringBeanDiscoverer.convertBeans(result, (Set<String>)existBeans, descriptors);
            });
        }
        ArrayList<CommonSpringBean> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "evaluateCustomComponents"));
        }
        return arrayList;
    }

    private static void addBeanIfClassExists(List<CommonSpringBean> result, Set<String> existBeans, GroovyPsiManager manager, GlobalSearchScope scope, String beanName, String className) {
        if (existBeans.contains(beanName)) {
            return;
        }
        PsiClass beanClass = manager.findClassWithCache(className, scope);
        if (beanClass != null) {
            result.add((CommonSpringBean)new GrailsCustomSpringComponent(beanClass, beanName));
            existBeans.add(beanName);
        }
    }

    private static void convertBeans(List<CommonSpringBean> result, Set<String> existBeans, Collection<GrailsResourceBeanExtractor.BeanDescriptor> descriptors) {
        for (GrailsResourceBeanExtractor.BeanDescriptor bean : descriptors) {
            PsiClass resolveResult;
            if (existBeans.contains(bean.getName()) || (resolveResult = (PsiClass)ourGuard.doPreventingRecursion((Object)bean, true, () -> {
                PsiType type = bean.getType();
                if (type instanceof PsiClassType) {
                    return ((PsiClassType)type).resolve();
                }
                return null;
            })) == null) continue;
            result.add((CommonSpringBean)new GrailsCustomSpringComponent(resolveResult, bean.getName()));
            existBeans.add(bean.getName());
        }
    }

    private static void addBeanFromResourceGroovy(List<CommonSpringBean> result, Set<String> existBeans, PsiManager manager, VirtualFile rootDirectory) {
        VirtualFile resourcesFile = VfsUtil.findRelativeFile((VirtualFile)rootDirectory, (String[])new String[]{"grails-app", "conf", "spring", "resources.groovy"});
        if (resourcesFile == null) {
            return;
        }
        PsiFile resourcePsiFile = manager.findFile(resourcesFile);
        if (!(resourcePsiFile instanceof GroovyFile)) {
            return;
        }
        List<GrailsResourceBeanExtractor.BeanDescriptor> descriptors = GrailsResourceBeanExtractor.getBeanDescriptorsFromResourcesGroovy((GroovyFile)resourcePsiFile);
        GrailsSpringBeanDiscoverer.convertBeans(result, existBeans, descriptors);
    }

    public Object[] getDependencies(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "getDependencies"));
        }
        return ArrayUtil.append((Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies(), (Object)PsiModificationTracker.MODIFICATION_COUNT);
    }

    @NotNull
    public String getProviderName() {
        if ("Grails Spring Beans" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/spring/GrailsSpringBeanDiscoverer", "getProviderName"));
        }
        return "Grails Spring Beans";
    }

    static {
        PLUGINS_BEAN_MAP.put((Object)"hibernate", Arrays.asList(Couple.of((Object)"hibernateProperties", (Object)"org.springframework.beans.factory.config.PropertiesFactoryBean"), Couple.of((Object)"sessionFactory", (Object)"org.codehaus.groovy.grails.orm.hibernate.ConfigurableLocalSessionFactoryBean"), Couple.of((Object)"transactionManager", (Object)"org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTransactionManager")));
        List<Couple> shiroBeans = Collections.singletonList(Couple.of((Object)"jsecSecurityManager", (Object)"org.jsecurity.web.DefaultWebSecurityManager"));
        PLUGINS_BEAN_MAP.put((Object)"shiro", shiroBeans);
        PLUGINS_BEAN_MAP.put((Object)"jsecurity", shiroBeans);
    }
}

