/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import icons.GroovyMvcIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.ReferenceGutterIconRenderer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class GrailsControllerAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/grails/annotator/GrailsControllerAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/grails/annotator/GrailsControllerAnnotator", "annotate"));
        }
        if (GrailsUtils.isControllerAction(element)) {
            PsiElement annotatedElement = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            if (annotatedElement == null) {
                return;
            }
            List<PsiFile> views = GrailsUtils.getViewPsiByAction(element);
            if (!views.isEmpty()) {
                NavigationGutterIconBuilder.create((Icon)GroovyMvcIcons.Gsp_logo).setTargets(views).setNamer(e -> e instanceof PsiNamedElement ? ((PsiNamedElement)e).getName() : null).install(holder, annotatedElement);
            }
            return;
        }
        if (element instanceof GrMethodCall && WebFlowUtils.isStateDeclaration((GrMethodCall)element, true)) {
            PsiFile gspFile;
            String stateName;
            VirtualFile gspVF;
            VirtualFile actionDir;
            GrMethodCall methodCall = (GrMethodCall)element;
            GrField actionDef = WebFlowUtils.getActionByStateDeclaration(methodCall);
            String actionName = GrailsUtils.getActionName((PsiElement)actionDef);
            VirtualFile controllerGspDir = GrailsUtils.getControllerGspDir(actionDef.getContainingClass());
            if (controllerGspDir != null && (actionDir = controllerGspDir.findChild(actionName)) != null && (gspVF = actionDir.findChild((stateName = WebFlowUtils.getStateNameByStateDeclaration(methodCall)) + ".gsp")) != null && (gspFile = actionDef.getManager().findFile(gspVF)) != null) {
                GrailsControllerAnnotator.createAnnotation(holder, (PsiElement)methodCall.getInvokedExpression(), gspFile);
            }
            return;
        }
    }

    private static void createAnnotation(AnnotationHolder holder, PsiElement element, @NotNull PsiFile gspFile) {
        if (gspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspFile", "org/jetbrains/plugins/groovy/grails/annotator/GrailsControllerAnnotator", "createAnnotation"));
        }
        Annotation annotation = holder.createInfoAnnotation(element, null);
        annotation.setGutterIconRenderer((GutterIconRenderer)new ReferenceGutterIconRenderer((Navigatable)gspFile, GroovyMvcIcons.Gsp_logo, gspFile.getName()));
    }
}

