/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesIndex;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesForm;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class DuplocateManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.DuplocateManager");
    private final Project myProject;
    private ContentManager myContentManager;

    public DuplocateManager(Project p) {
        this.myProject = p;
        StartupManager.getInstance((Project)p).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.DUPLICATES, true, ToolWindowAnchor.BOTTOM, (Disposable)p);
            this.myContentManager = toolWindow.getContentManager();
            new ContentManagerWatcher(toolWindow, this.myContentManager);
        });
    }

    public static DuplocateManager getInstance(Project p) {
        return (DuplocateManager)ServiceManager.getService((Project)p, DuplocateManager.class);
    }

    private static DuplocateVisitor[] createVisitors(DuplicatesProfile[] profiles, FragmentsCollector collector, DuplocatorSettings settings) {
        DuplocatorSettings.getInstance().loadState(settings);
        DuplocateVisitor[] visitors = new DuplocateVisitor[profiles.length];
        for (int i = 0; i < visitors.length; ++i) {
            visitors[i] = profiles[i].createVisitor(collector);
        }
        return visitors;
    }

    public static void hash(DuplocatorHashCallback duplicateCollector, DuplocatorSettings settings, AnalysisScope scope) {
        DuplicatesProfile javaProfile;
        Language javaLanguage = Language.findLanguageByID((String)"JAVA");
        if (javaLanguage != null && (javaProfile = DuplicatesProfile.findProfileForLanguage(javaLanguage)) != null) {
            DuplocateManager.hash(null, scope, duplicateCollector, new DuplicatesProfile[]{javaProfile}, settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hash(@Nullable Project project, AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        DuplicatesProfile[] profs;
        ArrayList<DuplicatesProfile> withIndex = new ArrayList<DuplicatesProfile>();
        ArrayList<DuplicatesProfile> withoutIndex = new ArrayList<DuplicatesProfile>();
        boolean useIndex = scope.getFileCount() > 500;
        for (DuplicatesProfile profile : profiles) {
            if (useIndex && project != null && profile.supportIndex()) {
                withIndex.add(profile);
                continue;
            }
            withoutIndex.add(profile);
        }
        if (withIndex.size() > 0) {
            DuplicatesIndex index;
            profs = withIndex.toArray(new DuplicatesProfile[withIndex.size()]);
            try {
                assert (project != null);
                index = new DuplicatesIndex(project, profs);
            }
            catch (IOException e) {
                LOG.warn("Duplicates index cannot be used", (Throwable)e);
                index = null;
            }
            if (index != null) {
                try {
                    index.update(scope);
                    index.processAll(scope, collector);
                }
                finally {
                    index.dispose();
                }
            } else {
                withoutIndex.addAll(withIndex);
            }
        }
        if (withoutIndex.size() > 0) {
            profs = withoutIndex.toArray(new DuplicatesProfile[withoutIndex.size()]);
            DuplocateManager.doHash(scope, collector, profs, settings);
        }
    }

    public static void doHash(AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        DuplocateVisitor[] visitors;
        for (DuplocateVisitor visitor : visitors = DuplocateManager.visitAll(scope, collector, profiles, settings)) {
            visitor.hashingFinished();
        }
    }

    private static DuplocateVisitor[] visitAll(AnalysisScope scope, FragmentsCollector collector, DuplicatesProfile[] profiles, DuplocatorSettings settings) {
        final int totalFiles = scope.getFileCount();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        final int[] fileCount = new int[]{0};
        if (indicator != null) {
            indicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
        }
        final DuplocateVisitor[] visitors = DuplocateManager.createVisitors(profiles, collector, settings);
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitFile(PsiFile baseFile) {
                Project project = baseFile.getProject();
                fileCount[0] = fileCount[0] + 1;
                if (indicator != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        indicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                    indicator.setFraction((double)fileCount[0] / (double)totalFiles);
                }
                try {
                    for (PsiFile file : baseFile.getViewProvider().getAllFiles()) {
                        for (DuplocateVisitor visitor : visitors) {
                            visitor.visitNode((PsiElement)file);
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)project);
                        psiManager.dropResolveCaches();
                        InjectedLanguageManager.getInstance((Project)project).dropFileCaches(file);
                    }
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        return visitors;
    }

    public void findAndShow(AnalysisScope scope, DuplocatorSettings settings, DuplicatesProfile[] profiles) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        DuplocatorHashCallback collector = new DuplocatorHashCallback(-1, -1);
        Runnable process = () -> {
            try {
                DuplocateManager.hash(this.myProject, scope, collector, profiles, settings);
            }
            catch (IndexNotReadyException e) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification("Analyze duplicates is not available until indices are ready");
                throw new ProcessCanceledException();
            }
        };
        Runnable successRunnable = () -> SwingUtilities.invokeLater(() -> {
            DupInfo info = collector.getInfo();
            if (info.getPatterns() > 0) {
                this.showDuplicates(info, scope, settings, profiles);
            } else {
                Messages.showInfoMessage((Project)this.myProject, (String)DupLocatorBundle.message("duplication.none.found.message", new Object[0]), (String)DupLocatorBundle.message("duplication.none.found.title", new Object[0]));
            }
        });
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(this.myProject, DupLocatorBundle.message("duplication.progress", new Object[0]), process, successRunnable, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject));
    }

    public void showDuplicates(DupInfo info, AnalysisScope scope, DuplocatorSettings settings) {
        int caretOffset = -1;
        this.showDuplicates(info, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", DuplicatesProfile.getAllProfiles());
    }

    public void showDuplicates(DupInfo info, int caretOffset, VirtualFile virtualFile, String title) {
        this.showDuplicates(info, null, null, caretOffset, virtualFile, title, DuplicatesProfile.getAllProfiles());
    }

    public void showDuplicates(DupInfo duplicates, AnalysisScope scope, DuplocatorSettings settings, DuplicatesProfile[] profiles) {
        int caretOffset = -1;
        this.showDuplicates(duplicates, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", profiles);
    }

    public void showDuplicates(DupInfo duplicates, AnalysisScope scope, DuplocatorSettings settings, final int caretOffset, final VirtualFile virtualFile, String title, DuplicatesProfile[] profiles) {
        DuplicatesForm form = DuplicatesForm.create(this.myProject, duplicates);
        if (caretOffset != -1 && virtualFile != null) {
            final JTree duplicatesTree = form.getDuplicatesTree();
            TreeUtil.traverse((TreeNode)((TreeNode)duplicatesTree.getModel().getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof CodeNode) {
                        CodeNode codeNode = (CodeNode)node;
                        try {
                            if (Comparing.equal((Object)codeNode.getVirtualFile(), (Object)virtualFile) && codeNode.getTextRange().contains(caretOffset)) {
                                TreeUtil.selectNode((JTree)duplicatesTree, (TreeNode)codeNode);
                                return false;
                            }
                        }
                        catch (InvalidatedException e) {
                            return true;
                        }
                    }
                    return true;
                }
            });
        }
        ContentPanel contentPanel = new ContentPanel(form.getComponent());
        if (scope != null && profiles != null) {
            contentPanel.addRerunAction(() -> {
                Content selectedContent = this.myContentManager.getSelectedContent();
                if (selectedContent != null) {
                    this.myContentManager.removeContent(selectedContent, true);
                }
                this.findAndShow(scope, settings, profiles);
            });
        }
        Content content = this.myContentManager.getFactory().createContent((JComponent)contentPanel.getComponent(), title, true);
        content.setDisposer((Disposable)form);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        contentPanel.addCloseAction(this.myContentManager, content);
        form.addToolbarActionsTo(contentPanel);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.DUPLICATES).activate(null);
    }
}

