/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SelectTemplateDialog;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

class EditVarConstraintsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog");
    private JTextField maxoccurs;
    private JCheckBox applyWithinTypeHierarchy;
    private JCheckBox notRegexp;
    private EditorTextField regexp;
    private JTextField minoccurs;
    private JPanel mainForm;
    private JCheckBox notWrite;
    private JCheckBox notRead;
    private JCheckBox write;
    private JCheckBox read;
    private JList parameterList;
    private JCheckBox partOfSearchResults;
    private JCheckBox notExprType;
    private EditorTextField regexprForExprType;
    private final Configuration myConfiguration;
    private JCheckBox exprTypeWithinHierarchy;
    private final List<Variable> variables;
    private Variable current;
    private JCheckBox wholeWordsOnly;
    private JCheckBox formalArgTypeWithinHierarchy;
    private JCheckBox invertFormalArgType;
    private EditorTextField formalArgType;
    private ComponentWithBrowseButton<EditorTextField> customScriptCode;
    private JCheckBox maxoccursUnlimited;
    private ComboboxWithBrowseButton withinCombo;
    private JPanel containedInConstraints;
    private JCheckBox invertWithinIn;
    private JPanel expressionConstraints;
    private JPanel occurencePanel;
    private JPanel textConstraintsPanel;
    private JLabel myRegExHelpLabel;
    private JButton myZeroZeroButton;
    private JButton myOneOneButton;
    private JButton myZeroInfinityButton;
    private JButton myOneInfinityButton;
    private JButton myZeroOneButton;
    private static Project myProject;

    EditVarConstraintsDialog(final Project project, Configuration configuration, List<Variable> _variables, final FileType fileType) {
        super(project, false);
        this.variables = _variables;
        this.myConfiguration = configuration;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(SSRBundle.message("editvarcontraints.edit.variables", objectArray));
        this.regexp.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(new JComponent[]{this.notRegexp, this.wholeWordsOnly}));
        this.regexp.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                EditVarConstraintsDialog.this.applyWithinTypeHierarchy.setEnabled(e.getDocument().getTextLength() > 0 && fileType == StdFileTypes.JAVA);
            }
        });
        this.myZeroZeroButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.this.minoccurs.setText("0");
                EditVarConstraintsDialog.this.maxoccurs.setText("0");
                EditVarConstraintsDialog.this.maxoccursUnlimited.setSelected(false);
            }
        });
        this.myZeroOneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.this.minoccurs.setText("0");
                EditVarConstraintsDialog.this.maxoccurs.setText("1");
                EditVarConstraintsDialog.this.maxoccursUnlimited.setSelected(false);
            }
        });
        this.myOneOneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.this.minoccurs.setText("1");
                EditVarConstraintsDialog.this.maxoccurs.setText("1");
                EditVarConstraintsDialog.this.maxoccursUnlimited.setSelected(false);
            }
        });
        this.myZeroInfinityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.this.minoccurs.setText("0");
                EditVarConstraintsDialog.this.maxoccursUnlimited.setSelected(true);
            }
        });
        this.myOneInfinityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditVarConstraintsDialog.this.minoccurs.setText("1");
                EditVarConstraintsDialog.this.maxoccursUnlimited.setSelected(true);
            }
        });
        this.read.addChangeListener(new MyChangeListener(this.notRead, false));
        this.write.addChangeListener(new MyChangeListener(this.notWrite, false));
        this.regexprForExprType.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(new JComponent[]{this.exprTypeWithinHierarchy, this.notExprType}));
        this.formalArgType.getDocument().addDocumentListener((DocumentListener)new MyDocumentListener(new JComponent[]{this.formalArgTypeWithinHierarchy, this.invertFormalArgType}));
        this.containedInConstraints.setVisible(false);
        this.withinCombo.getComboBox().setEditable(true);
        this.withinCombo.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                Configuration[] selectedConfigurations;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog$7", "actionPerformed"));
                }
                SelectTemplateDialog dialog = new SelectTemplateDialog(project, false, false);
                dialog.show();
                if (dialog.getExitCode() == 0 && (selectedConfigurations = dialog.getSelectedConfigurations()).length == 1) {
                    EditVarConstraintsDialog.this.withinCombo.getComboBox().getEditor().setItem(selectedConfigurations[0].getMatchOptions().getSearchPattern());
                }
            }
        });
        boolean hasContextVar = false;
        for (Variable var : this.variables) {
            if (!"__context__".equals(var.getName())) continue;
            hasContextVar = true;
            break;
        }
        if (!hasContextVar) {
            this.variables.add(new Variable("__context__", "", "", true));
        }
        if (fileType == StdFileTypes.JAVA) {
            this.formalArgTypeWithinHierarchy.setEnabled(true);
            this.invertFormalArgType.setEnabled(true);
            this.formalArgType.setEnabled(true);
            this.exprTypeWithinHierarchy.setEnabled(true);
            this.notExprType.setEnabled(true);
            this.regexprForExprType.setEnabled(true);
            this.read.setEnabled(true);
            this.notRead.setEnabled(false);
            this.write.setEnabled(true);
            this.notWrite.setEnabled(false);
            this.applyWithinTypeHierarchy.setEnabled(true);
        } else {
            this.formalArgTypeWithinHierarchy.setEnabled(false);
            this.invertFormalArgType.setEnabled(false);
            this.formalArgType.setEnabled(false);
            this.exprTypeWithinHierarchy.setEnabled(false);
            this.notExprType.setEnabled(false);
            this.regexprForExprType.setEnabled(false);
            this.read.setEnabled(false);
            this.notRead.setEnabled(false);
            this.write.setEnabled(false);
            this.notWrite.setEnabled(false);
            this.applyWithinTypeHierarchy.setEnabled(false);
        }
        this.parameterList.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return EditVarConstraintsDialog.this.variables.get(index);
            }

            @Override
            public int getSize() {
                return EditVarConstraintsDialog.this.variables.size();
            }
        });
        this.parameterList.setSelectionMode(0);
        this.parameterList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            boolean rollingBackSelection;

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog$9", "valueChanged"));
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (this.rollingBackSelection) {
                    this.rollingBackSelection = false;
                    return;
                }
                Variable var = (Variable)EditVarConstraintsDialog.this.variables.get(EditVarConstraintsDialog.this.parameterList.getSelectedIndex());
                if (EditVarConstraintsDialog.this.validateParameters()) {
                    if (EditVarConstraintsDialog.this.current != null) {
                        EditVarConstraintsDialog.this.copyValuesFromUI(EditVarConstraintsDialog.this.current);
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> EditVarConstraintsDialog.this.copyValuesToUI(var));
                    EditVarConstraintsDialog.this.current = var;
                } else {
                    this.rollingBackSelection = true;
                    EditVarConstraintsDialog.this.parameterList.setSelectedIndex(e.getFirstIndex() == EditVarConstraintsDialog.this.parameterList.getSelectedIndex() ? e.getLastIndex() : e.getFirstIndex());
                }
            }
        });
        this.parameterList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog$10", "getListCellRendererComponent"));
                }
                String name = ((Variable)value).getName();
                if ("__context__".equals(name)) {
                    name = SSRBundle.message("complete.match.variable.name", new Object[0]);
                }
                if (EditVarConstraintsDialog.isReplacementVariable(name)) {
                    name = EditVarConstraintsDialog.stripReplacementVarDecoration(name);
                }
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.maxoccursUnlimited.addChangeListener(new MyChangeListener(this.maxoccurs, true));
        this.customScriptCode.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog$11", "actionPerformed"));
                }
                ArrayList variableNames = ContainerUtil.newArrayList(EditVarConstraintsDialog.this.myConfiguration.getMatchOptions().getVariableConstraintNames());
                variableNames.add("__log__");
                variableNames.remove("__class_unmatched__");
                EditScriptDialog dialog = new EditScriptDialog(project, ((EditorTextField)EditVarConstraintsDialog.this.customScriptCode.getChildComponent()).getText(), variableNames);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    ((EditorTextField)EditVarConstraintsDialog.this.customScriptCode.getChildComponent()).setText(dialog.getScriptText());
                }
            }
        });
        this.init();
        if (this.variables.size() > 0) {
            this.parameterList.setSelectedIndex(0);
        }
    }

    private static String stripReplacementVarDecoration(String name) {
        name = name.substring(0, name.length() - "$replacement".length());
        return name;
    }

    private static boolean isReplacementVariable(String name) {
        return name.endsWith("$replacement");
    }

    private boolean validateParameters() {
        return EditVarConstraintsDialog.validateRegExp(this.regexp) && EditVarConstraintsDialog.validateRegExp(this.regexprForExprType) && EditVarConstraintsDialog.validateIntOccurence(this.minoccurs) && EditVarConstraintsDialog.validateScript((EditorTextField)this.customScriptCode.getChildComponent()) && (this.maxoccursUnlimited.isSelected() || EditVarConstraintsDialog.validateIntOccurence(this.maxoccurs));
    }

    protected JComponent createCenterPanel() {
        return this.mainForm;
    }

    protected void doOKAction() {
        if (this.validateParameters()) {
            if (this.current != null) {
                this.copyValuesFromUI(this.current);
            }
            super.doOKAction();
        }
    }

    void copyValuesFromUI(Variable var) {
        String varName = var.getName();
        if (EditVarConstraintsDialog.isReplacementVariable(varName)) {
            this.saveScriptInfo(EditVarConstraintsDialog.getOrAddReplacementVariableDefinition(varName, this.myConfiguration));
            return;
        }
        MatchVariableConstraint varInfo = UIUtil.getOrAddVariableConstraint(varName, this.myConfiguration);
        varInfo.setInvertReadAccess(this.notRead.isSelected());
        varInfo.setReadAccess(this.read.isSelected());
        varInfo.setInvertWriteAccess(this.notWrite.isSelected());
        varInfo.setWriteAccess(this.write.isSelected());
        varInfo.setRegExp(this.regexp.getDocument().getText());
        varInfo.setInvertRegExp(this.notRegexp.isSelected());
        int minCount = Integer.parseInt(this.minoccurs.getText());
        varInfo.setMinCount(minCount);
        int maxCount = this.maxoccursUnlimited.isSelected() ? Integer.MAX_VALUE : Integer.parseInt(this.maxoccurs.getText());
        varInfo.setMaxCount(maxCount);
        varInfo.setWithinHierarchy(this.applyWithinTypeHierarchy.isSelected());
        varInfo.setInvertRegExp(this.notRegexp.isSelected());
        boolean target = this.partOfSearchResults.isSelected();
        if (target) {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                if (name.equals(varName)) continue;
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(false);
            }
        }
        varInfo.setPartOfSearchResults(target);
        varInfo.setInvertExprType(this.notExprType.isSelected());
        varInfo.setNameOfExprType(this.regexprForExprType.getDocument().getText());
        varInfo.setExprTypeWithinHierarchy(this.exprTypeWithinHierarchy.isSelected());
        varInfo.setWholeWordsOnly(this.wholeWordsOnly.isSelected());
        varInfo.setInvertFormalType(this.invertFormalArgType.isSelected());
        varInfo.setFormalArgTypeWithinHierarchy(this.formalArgTypeWithinHierarchy.isSelected());
        varInfo.setNameOfFormalArgType(this.formalArgType.getDocument().getText());
        this.saveScriptInfo(varInfo);
        String withinConstraint = (String)this.withinCombo.getComboBox().getEditor().getItem();
        varInfo.setWithinConstraint(withinConstraint.length() > 0 ? "\"" + withinConstraint + "\"" : "");
        varInfo.setInvertWithinConstraint(this.invertWithinIn.isSelected());
    }

    private static ReplacementVariableDefinition getOrAddReplacementVariableDefinition(String varName, Configuration configuration) {
        String realVariableName;
        ReplaceOptions replaceOptions = ((ReplaceConfiguration)configuration).getOptions();
        ReplacementVariableDefinition variableDefinition = replaceOptions.getVariableDefinition(realVariableName = EditVarConstraintsDialog.stripReplacementVarDecoration(varName));
        if (variableDefinition == null) {
            variableDefinition = new ReplacementVariableDefinition();
            variableDefinition.setName(realVariableName);
            replaceOptions.addVariableDefinition(variableDefinition);
        }
        return variableDefinition;
    }

    private void saveScriptInfo(NamedScriptableDefinition varInfo) {
        varInfo.setScriptCodeConstraint("\"" + ((EditorTextField)this.customScriptCode.getChildComponent()).getText() + "\"");
    }

    private void copyValuesToUI(Variable var) {
        String varName = var.getName();
        if (EditVarConstraintsDialog.isReplacementVariable(varName)) {
            ReplacementVariableDefinition definition = ((ReplaceConfiguration)this.myConfiguration).getOptions().getVariableDefinition(EditVarConstraintsDialog.stripReplacementVarDecoration(varName));
            this.restoreScriptCode(definition);
            this.setSearchConstraintsVisible(false);
            return;
        }
        this.setSearchConstraintsVisible(true);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        MatchVariableConstraint varInfo = matchOptions.getVariableConstraint(varName);
        if (varInfo == null) {
            this.notRead.setSelected(false);
            this.notRegexp.setSelected(false);
            this.read.setSelected(false);
            this.notWrite.setSelected(false);
            this.write.setSelected(false);
            this.regexp.getDocument().setText((CharSequence)"");
            this.minoccurs.setText("1");
            this.maxoccurs.setText("1");
            this.maxoccursUnlimited.setSelected(false);
            this.applyWithinTypeHierarchy.setSelected(false);
            this.partOfSearchResults.setSelected(UIUtil.isTarget(varName, matchOptions));
            this.regexprForExprType.getDocument().setText((CharSequence)"");
            this.notExprType.setSelected(false);
            this.exprTypeWithinHierarchy.setSelected(false);
            this.wholeWordsOnly.setSelected(false);
            this.invertFormalArgType.setSelected(false);
            this.formalArgTypeWithinHierarchy.setSelected(false);
            this.formalArgType.getDocument().setText((CharSequence)"");
            ((EditorTextField)this.customScriptCode.getChildComponent()).setText("");
            this.withinCombo.getComboBox().getEditor().setItem("");
            this.invertWithinIn.setSelected(false);
        } else {
            this.notRead.setSelected(varInfo.isInvertReadAccess());
            this.read.setSelected(varInfo.isReadAccess());
            this.notWrite.setSelected(varInfo.isInvertWriteAccess());
            this.write.setSelected(varInfo.isWriteAccess());
            this.applyWithinTypeHierarchy.setSelected(varInfo.isWithinHierarchy());
            this.regexp.getDocument().setText((CharSequence)varInfo.getRegExp());
            this.notRegexp.setSelected(varInfo.isInvertRegExp());
            this.minoccurs.setText(Integer.toString(varInfo.getMinCount()));
            if (varInfo.getMaxCount() == Integer.MAX_VALUE) {
                this.maxoccursUnlimited.setSelected(true);
                this.maxoccurs.setText("");
            } else {
                this.maxoccursUnlimited.setSelected(false);
                this.maxoccurs.setText(Integer.toString(varInfo.getMaxCount()));
            }
            this.partOfSearchResults.setSelected(UIUtil.isTarget(varName, matchOptions));
            this.exprTypeWithinHierarchy.setSelected(varInfo.isExprTypeWithinHierarchy());
            this.regexprForExprType.getDocument().setText((CharSequence)varInfo.getNameOfExprType());
            this.notExprType.setSelected(varInfo.isInvertExprType());
            this.wholeWordsOnly.setSelected(varInfo.isWholeWordsOnly());
            this.invertFormalArgType.setSelected(varInfo.isInvertFormalType());
            this.formalArgTypeWithinHierarchy.setSelected(varInfo.isFormalArgTypeWithinHierarchy());
            this.formalArgType.getDocument().setText((CharSequence)varInfo.getNameOfFormalArgType());
            this.restoreScriptCode(varInfo);
            this.withinCombo.getComboBox().getEditor().setItem(StringUtil.stripQuotesAroundValue((String)varInfo.getWithinConstraint()));
            this.invertWithinIn.setSelected(varInfo.isInvertWithinConstraint());
        }
        boolean contextVar = "__context__".equals(var.getName());
        this.containedInConstraints.setVisible(contextVar);
        this.textConstraintsPanel.setVisible(!contextVar);
        this.partOfSearchResults.setEnabled(!contextVar);
        this.occurencePanel.setVisible(!contextVar);
    }

    private void setSearchConstraintsVisible(boolean b) {
        this.textConstraintsPanel.setVisible(b);
        this.occurencePanel.setVisible(b);
        this.expressionConstraints.setVisible(b);
        this.partOfSearchResults.setVisible(b);
        this.containedInConstraints.setVisible(b);
    }

    private void restoreScriptCode(NamedScriptableDefinition varInfo) {
        ((EditorTextField)this.customScriptCode.getChildComponent()).setText(varInfo != null ? StringUtil.stripQuotesAroundValue((String)varInfo.getScriptCodeConstraint()) : "");
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.ui.EditVarConstraintsDialog";
    }

    private static boolean validateRegExp(EditorTextField field) {
        String s = field.getDocument().getText();
        try {
            if (s.length() > 0) {
                Pattern.compile(s);
            }
        }
        catch (PatternSyntaxException ex) {
            Messages.showErrorDialog((String)SSRBundle.message("invalid.regular.expression", ex.getMessage()), (String)SSRBundle.message("invalid.regular.expression.title", new Object[0]));
            field.requestFocus();
            return false;
        }
        return true;
    }

    private static boolean validateScript(EditorTextField field) {
        String message;
        String text = field.getText();
        if (text.length() > 0 && (message = ScriptSupport.checkValidScript(text)) != null) {
            Messages.showErrorDialog((String)message, (String)SSRBundle.message("invalid.groovy.script", new Object[0]));
            field.requestFocus();
            return false;
        }
        return true;
    }

    private static boolean validateIntOccurence(JTextField field) {
        try {
            if (Integer.parseInt(field.getText()) < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            Messages.showErrorDialog((String)SSRBundle.message("invalid.occurence.count", new Object[0]), (String)SSRBundle.message("invalid.occurence.count", new Object[0]));
            field.requestFocus();
            return false;
        }
        return true;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.dialogs.search.replace.structural.editvariable");
    }

    private void createUIComponents() {
        this.regexp = EditVarConstraintsDialog.createRegexComponent();
        this.regexprForExprType = EditVarConstraintsDialog.createRegexComponent();
        this.formalArgType = EditVarConstraintsDialog.createRegexComponent();
        this.customScriptCode = new ComponentWithBrowseButton((JComponent)EditVarConstraintsDialog.createScriptComponent(), null);
        this.myRegExHelpLabel = RegExHelpPopup.createRegExLink((String)SSRBundle.message("regular.expression.help.label", new Object[0]), (Component)this.regexp, (Logger)LOG);
        this.myRegExHelpLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
    }

    private static EditorTextField createRegexComponent() {
        String fileName = "1.regexp";
        FileType fileType = EditVarConstraintsDialog.getFileType("1.regexp");
        Document doc = EditVarConstraintsDialog.createDocument("1.regexp", fileType, "");
        return new EditorTextField(doc, myProject, fileType);
    }

    private static EditorTextField createScriptComponent() {
        String fileName = "1.groovy";
        FileType fileType = EditVarConstraintsDialog.getFileType("1.groovy");
        Document doc = EditVarConstraintsDialog.createDocument("1.groovy", fileType, "");
        return new EditorTextField(doc, myProject, fileType);
    }

    private static Document createDocument(String fileName, FileType fileType, String text) {
        PsiFile file = PsiFileFactory.getInstance((Project)myProject).createFileFromText(fileName, fileType, (CharSequence)text, -1L, true);
        return PsiDocumentManager.getInstance((Project)myProject).getDocument(file);
    }

    private static FileType getFileType(String fileName) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        return fileType;
    }

    public static void setProject(Project project) {
        myProject = project;
    }

    private static Editor createEditor(Project project, String text, String fileName) {
        FileType fileType = EditVarConstraintsDialog.getFileType(fileName);
        Document doc = EditVarConstraintsDialog.createDocument(fileName, fileType, text);
        Editor editor = EditorFactory.getInstance().createEditor(doc, project);
        ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setRightMarginShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        ((EditorEx)editor).setHighlighter(HighlighterFactory.createHighlighter((FileType)fileType, (EditorColorsScheme)DefaultColorSchemesManager.getInstance().getFirstScheme(), (Project)project));
        return editor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel3;
        JCheckBox jCheckBox12;
        JCheckBox jCheckBox13;
        JCheckBox jCheckBox14;
        JPanel jPanel4;
        JPanel jPanel5;
        this.createUIComponents();
        this.mainForm = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 8, 1, 0, 3, 3, 3, new Dimension(150, -1), new Dimension(150, -1), new Dimension(150, -1)));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.variables.border"), (int)0, (int)0, null, null));
        JBList jBList = new JBList();
        this.parameterList = jBList;
        jPanel6.add((Component)jBList, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 6, null, new Dimension(150, 50), null));
        this.textConstraintsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 0, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.text.constraints.border"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.regexp;
        jPanel4.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.applyWithinTypeHierarchy = jCheckBox14 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel4.add((Component)jCheckBox14, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.notRegexp = jCheckBox13 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel4.add((Component)jCheckBox13, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.wholeWordsOnly = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.whole.words.only"));
        jPanel4.add((Component)jCheckBox12, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.expressionConstraints = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel3, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 0, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.expression.constraints.border"), (int)0, (int)0, null, null));
        this.read = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.value.is.read"));
        jPanel3.add((Component)jCheckBox11, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.write = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.value.is.written"));
        jPanel3.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.notRead = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel3.add((Component)jCheckBox9, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.notWrite = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel3.add((Component)jCheckBox8, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        EditorTextField editorTextField2 = this.regexprForExprType;
        jPanel3.add((Component)editorTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.exprTypeWithinHierarchy = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.notExprType = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression.for.java.expression.type"));
        jPanel3.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.text.regular.expression.for.formal.argument.type.of.the.method"));
        jPanel3.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField3 = this.formalArgType;
        jPanel3.add((Component)editorTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.invertFormalArgType = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.formalArgTypeWithinHierarchy = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.apply.constraint.within.type.hierarchy"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.partOfSearchResults = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.this.variable.is.target.of.the.search"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(6, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(7, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.occurencePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel2, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 0, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.occurrences.count.border"), (int)0, (int)0, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.minimum.count"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.minoccurs = jTextField2 = new JTextField();
        jTextField2.setText("1");
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.maximum.count"));
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.maxoccurs = jTextField = new JTextField();
        jTextField.setText("1");
        jTextField.setColumns(0);
        jPanel2.add((Component)jTextField, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), null));
        this.maxoccursUnlimited = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.unlimited"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myZeroZeroButton = jButton5 = new JButton();
        jButton5.setText("0,0");
        jButton5.setMargin(new Insets(0, 10, 0, 2));
        jPanel7.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOneOneButton = jButton4 = new JButton();
        jButton4.setText("1,1");
        jPanel7.add((Component)jButton4, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myOneInfinityButton = jButton3 = new JButton();
        jButton3.setText("1,\u221e");
        jPanel7.add((Component)jButton3, new GridConstraints(0, 4, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myZeroOneButton = jButton2 = new JButton();
        jButton2.setText("0,1");
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myZeroInfinityButton = jButton = new JButton();
        jButton.setText("0,\u221e");
        jPanel7.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.containedInConstraints = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Contained in constraints", (int)0, (int)0, null, null));
        this.withinCombo = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.invertWithinIn = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/SSRBundle").getString("editvarcontraints.invert.condition"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel6 = this.myRegExHelpLabel;
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 1, 1, 2, 4, 0, 0, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel5.add((Component)jPanel8, new GridConstraints(5, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/SSRBundle").getString("var.constraints.script.constraints.border"), (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/SSRBundle").getString("script.option.text"));
        jPanel8.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComponentWithBrowseButton<EditorTextField> componentWithBrowseButton = this.customScriptCode;
        jPanel8.add((Component)componentWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainForm;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class EditScriptDialog
    extends DialogWrapper {
        private final Editor editor;
        private final String title;

        public EditScriptDialog(Project project, String text, Collection<String> names) {
            super(project, true);
            this.setTitle(SSRBundle.message("edit.groovy.script.constraint.title", new Object[0]));
            this.editor = EditVarConstraintsDialog.createEditor(project, text, "1.groovy");
            this.title = names.size() > 0 ? "Available variables: " + StringUtil.join(names, (String)", ") : "";
            this.init();
        }

        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.editor.getContentComponent();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)this.editor.getComponent(), "Center");
            if (!this.title.isEmpty()) {
                panel.add((Component)new JLabel(this.title), "South");
            }
            return panel;
        }

        String getScriptText() {
            return this.editor.getDocument().getText();
        }

        protected void dispose() {
            EditorFactory.getInstance().releaseEditor(this.editor);
            super.dispose();
        }
    }

    private static class MyDocumentListener
    extends DocumentAdapter {
        private final JComponent[] components;

        private MyDocumentListener(JComponent ... _components) {
            this.components = _components;
        }

        public void documentChanged(DocumentEvent e) {
            boolean enable = e.getDocument().getTextLength() > 0;
            for (JComponent component : this.components) {
                component.setEnabled(enable);
            }
        }
    }

    private static class MyChangeListener
    implements ChangeListener {
        private final JComponent component;
        private final boolean inverted;

        MyChangeListener(JComponent _component, boolean _inverted) {
            this.component = _component;
            this.inverted = _inverted;
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/EditVarConstraintsDialog$MyChangeListener", "stateChanged"));
            }
            JCheckBox jCheckBox = (JCheckBox)e.getSource();
            this.component.setEnabled(this.inverted ^ jCheckBox.isSelected());
        }
    }
}

