/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deleteattribute;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.sixrr.xrp.base.BaseAttributeRefactoringHandler;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.deleteattribute.DeleteAttributeDialog;
import com.sixrr.xrp.deleteattribute.DeleteAttributeProcessor;

class DeleteAttributeHandler
extends BaseAttributeRefactoringHandler {
    DeleteAttributeHandler() {
    }

    @Override
    protected String getHelpID() {
        return "refactoring.deleteAttribute";
    }

    @Override
    protected String getRefactoringName() {
        return "Delete attribute";
    }

    @Override
    protected void handleAttribute(XmlAttribute attribute, Project project) {
        DeleteAttributeDialog dialog = new DeleteAttributeDialog(attribute);
        if (!dialog.showAndGet()) {
            return;
        }
        Context context = dialog.getContext();
        boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            Runnable action = () -> {
                DeleteAttributeProcessor processor = new DeleteAttributeProcessor(attribute, context, previewUsages);
                processor.run();
            };
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(action);
        }, "Delete Attribute", null);
    }
}

