/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.completion.CssDumbAwareCompletionContributor;
import com.intellij.psi.css.impl.util.completion.CssImportantInsertHandler;
import com.intellij.psi.css.impl.util.completion.provider.CssAtKeywordsCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.PropertyNamesCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.PseudoSelectorsCompletionProvider;
import com.intellij.psi.css.impl.util.completion.provider.TagsCompletionProvider;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.completion.provider.LessGuardKeywordsCompletionProvider;
import org.jetbrains.plugins.less.completion.provider.LessImportTypeCompletionProvider;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSGuardImpl;
import org.jetbrains.plugins.less.psi.impl.LESSMixinName;
import org.jetbrains.plugins.less.psi.impl.LessImportType;
import org.jetbrains.plugins.less.psi.impl.LessParameterList;

public class LessDumbAwareCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final TokenSet BLOCK_START_OR_END_SET = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_RBRACE});

    public LessDumbAwareCompletionContributor() {
        this.extend(CompletionType.BASIC, LessDumbAwareCompletionContributor.selector(), (CompletionProvider)new TagsCompletionProvider());
        this.extend(CompletionType.BASIC, LessDumbAwareCompletionContributor.guardKeywords(), new LessGuardKeywordsCompletionProvider());
        this.extend(CompletionType.BASIC, LessDumbAwareCompletionContributor.pseudoInsideBlock(), (CompletionProvider)new PseudoSelectorsCompletionProvider());
        this.extend(CompletionType.BASIC, LessDumbAwareCompletionContributor.importType(), new LessImportTypeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)LessDumbAwareCompletionContributor.propertyName(), (CompletionProvider)new PropertyNamesCompletionProvider());
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/LessDumbAwareCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/LessDumbAwareCompletionContributor", "fillCompletionVariants"));
        }
        result = CssCompletionUtil.fixPrefixForVendorPrefixes((CompletionParameters)parameters, (CompletionResultSet)result, (IElementType[])new IElementType[]{LESSTokenTypes.VARIABLE});
        super.fillCompletionVariants(parameters, result);
        if (!result.isStopped()) {
            PsiElement position = parameters.getPosition();
            if (CssPsiUtil.getStylesheetLanguage((PsiElement)position) == LESSLanguage.INSTANCE && CssDumbAwareCompletionContributor.atKeyword().accepts((Object)position)) {
                LessDumbAwareCompletionContributor.addAtKeyword("@import-once", result);
                LessDumbAwareCompletionContributor.addAtKeyword("@plugin", result);
            }
            if (LessDumbAwareCompletionContributor.importantMixinOrVariable().accepts((Object)position)) {
                result.addElement(CssCompletionUtil.lookupForKeyword((String)"important", (InsertHandler)CssImportantInsertHandler.INSTANCE));
                result.stopHere();
            }
        }
    }

    private static PsiElementPattern.Capture<PsiElement> importantMixinOrVariable() {
        return (PsiElementPattern.Capture)LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).afterLeafSkipping(StandardPatterns.alwaysFalse(), (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("!")).andOr(new ElementPattern[]{PlatformPatterns.psiElement().inside(LESSVariableDeclaration.class), PlatformPatterns.psiElement().afterSibling((ElementPattern)PlatformPatterns.psiElement(LESSMixinInvocation.class))}));
    }

    private static void addAtKeyword(@NotNull String lookupString, @NotNull CompletionResultSet result) {
        if (lookupString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupString", "org/jetbrains/plugins/less/completion/LessDumbAwareCompletionContributor", "addAtKeyword"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/LessDumbAwareCompletionContributor", "addAtKeyword"));
        }
        result.addElement(CssCompletionUtil.lookupForKeyword((String)lookupString, (InsertHandler)Lazy.KEYWORD_INSERT_HANDLER));
    }

    private static ElementPattern<PsiElement> selector() {
        return LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).andOr(new ElementPattern[]{LessDumbAwareCompletionContributor.propertyName(), CssDumbAwareCompletionContributor.propertyName()});
    }

    private static ElementPattern<? extends PsiElement> pseudoInsideBlock() {
        return ((PsiElementPattern.Capture)LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).withParent((ElementPattern)PlatformPatterns.psiElement(CssTerm.class).withSuperParent(2, CssDeclaration.class))).afterLeafSkipping(LessDumbAwareCompletionContributor.emptyElement(), (ElementPattern)PlatformPatterns.psiElement((IElementType)CssElementTypes.CSS_COLON));
    }

    private static ElementPattern<? extends PsiElement> importType() {
        return LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).inside(LessImportType.class);
    }

    private static ElementPattern<? extends PsiElement> guardKeywords() {
        return LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).andOr(new ElementPattern[]{PlatformPatterns.psiElement().inside(LESSGuardImpl.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().andNot((ElementPattern)PlatformPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(LESSMixinName.class), PlatformPatterns.psiElement(LESSMixinInvocation.class), PlatformPatterns.psiElement(LessParameterList.class)})))).afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withParent(LESSMixinInvocation.class), PlatformPatterns.psiElement().withElementType(LESSTokenTypes.GUARD_KEYWORDS), PlatformPatterns.psiElement().withParent(LESSMixinName.class), PlatformPatterns.psiElement().inside(CssSimpleSelector.class)}))});
    }

    private static ElementPattern<? extends PsiElement> atKeywords() {
        return LessDumbAwareCompletionContributor.inLessFile(LESSTokenTypes.VARIABLE).withParent((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement((IElementType)LESSElementTypes.LESS_VARIABLE)));
    }

    private static PsiElementPattern.Capture<PsiElement> propertyName() {
        return (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)LessDumbAwareCompletionContributor.inLessFile(CssElementTypes.CSS_IDENT).withParent(CssSimpleSelector.class)).inside(CssBlock.class)).afterLeafSkipping(StandardPatterns.or((ElementPattern[])new ElementPattern[]{LessDumbAwareCompletionContributor.emptyElement(), LessDumbAwareCompletionContributor.spaceElement()}), LessDumbAwareCompletionContributor.blockStartOrEnd())).beforeLeafSkipping(StandardPatterns.or((ElementPattern[])new ElementPattern[]{LessDumbAwareCompletionContributor.emptyElement(), LessDumbAwareCompletionContributor.spaceElement()}), LessDumbAwareCompletionContributor.blockStartOrEnd());
    }

    private static ElementPattern<PsiElement> blockStartOrEnd() {
        return StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withElementType(BLOCK_START_OR_END_SET), PlatformPatterns.psiElement().withText((ElementPattern)StandardPatterns.string().contains("\n"))});
    }

    private static PsiElementPattern.Capture<PsiElement> emptyElement() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("");
    }

    private static PsiElementPattern.Capture<PsiElement> spaceElement() {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(" ");
    }

    private static PsiElementPattern.Capture<PsiElement> inLessFile(IElementType type) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)type).inside((ElementPattern)PlatformPatterns.psiElement((IElementType)LESSElementTypes.LESS_STYLESHEET));
    }

    private static class Lazy {
        private static final CssAtKeywordsCompletionProvider.AddQuotesInsertHandler KEYWORD_INSERT_HANDLER = new CssAtKeywordsCompletionProvider.AddQuotesInsertHandler(";");

        private Lazy() {
        }
    }
}

