/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerAnchorProvider;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorElementInfoFactory
extends SmartPointerElementInfoFactory {
    @Override
    @Nullable
    public SmartPointerElementInfo createElementInfo(@NotNull PsiElement element, @NotNull PsiFile containingFile) {
        PsiElement anchor2;
        PsiFileWithStubSupport stubFile;
        StubTree stubTree;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory", "createElementInfo"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory", "createElementInfo"));
        }
        if (element instanceof StubBasedPsiElement && containingFile instanceof PsiFileWithStubSupport && (stubTree = (stubFile = (PsiFileWithStubSupport)containingFile).getStubTree()) != null) {
            StubBasedPsiElement stubPsi = (StubBasedPsiElement)element;
            int stubId = PsiAnchor.calcStubIndex(stubPsi);
            IStubElementType myStubElementType = stubPsi.getElementType();
            IStubFileElementType elementTypeForStubBuilder = ((PsiFileImpl)containingFile).getElementTypeForStubBuilder();
            if (stubId != -1 && elementTypeForStubBuilder != null) {
                return new AnchorElementInfo(element, stubFile, stubId, myStubElementType);
            }
        }
        if ((anchor2 = AnchorElementInfoFactory.getAnchor(element)) != null) {
            return new AnchorElementInfo(anchor2, containingFile);
        }
        return null;
    }

    @Nullable
    static PsiElement getAnchor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorElementInfoFactory", "getAnchor"));
        }
        PsiUtilCore.ensureValid(element);
        if (!element.isPhysical()) {
            return null;
        }
        for (SmartPointerAnchorProvider provider : SmartPointerAnchorProvider.EP_NAME.getExtensions()) {
            PsiElement anchor2 = provider.getAnchor(element);
            if (anchor2 == null || !anchor2.isPhysical() || AnchorElementInfo.restoreFromAnchor(anchor2) != element) continue;
            return anchor2;
        }
        return null;
    }
}

