/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaBreakpointHandler;
import com.intellij.debugger.engine.JavaBreakpointHandlerFactory;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

final class NashornJsBreakpointHandlerFactory
implements JavaBreakpointHandlerFactory {
    NashornJsBreakpointHandlerFactory() {
    }

    public JavaBreakpointHandler createHandler(DebugProcessImpl process) {
        return new JavaBreakpointHandler(JavaScriptBreakpointType.class, process){

            @Nullable
            protected Breakpoint createJavaBreakpoint(@NotNull XBreakpoint xBreakpoint) {
                if (xBreakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xBreakpoint", "com/intellij/javascript/debugger/nashorn/NashornJsBreakpointHandlerFactory$1", "createJavaBreakpoint"));
                }
                NashornLineBreakpoint breakpoint = new NashornLineBreakpoint(this.myProcess.getProject(), xBreakpoint);
                return breakpoint.init();
            }
        };
    }

    private static class NashornLineBreakpoint
    extends LineBreakpoint {
        private final JavaLineBreakpointProperties myProperties = new JavaLineBreakpointProperties();

        private NashornLineBreakpoint(Project project, XBreakpoint xBreakpoint) {
            super(project, xBreakpoint);
        }

        @NotNull
        public JavaLineBreakpointProperties getProperties() {
            JavaLineBreakpointProperties javaLineBreakpointProperties = this.myProperties;
            if (javaLineBreakpointProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornJsBreakpointHandlerFactory$NashornLineBreakpoint", "getProperties"));
            }
            return javaLineBreakpointProperties;
        }

        @Nullable
        public String getPackageName() {
            return null;
        }

        @Nullable
        public String getClassName() {
            return null;
        }
    }
}

