/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.el;

import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.security.highlighting.SpringSecuritySpElAccessInjector;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.prepost.PostAuthorize", "org.springframework.security.access.prepost.PostFilter"});

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
        }
        PsiElement context = element.getContext();
        if (context == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
            }
            return list;
        }
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(ModuleUtilCore.findModuleForPsiElement((PsiElement)context));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
        }
        return set;
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
        }
        PsiElement context = psiElement.getContext();
        if (context == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method != null) {
            Collections.addAll(variables, method.getParameterList().getParameters());
        }
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
        }
        return list;
    }

    private static boolean acceptContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "acceptContext"));
        }
        return SpringSecurityELContextVariables.isSecurityAnnotation(context) || SpringSecurityELContextVariables.isXmlAccess(context);
    }

    private static boolean isSecurityAnnotation(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "isSecurityAnnotation"));
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
        return annotation != null && ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static boolean isXmlAccess(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "isXmlAccess"));
        }
        return context instanceof XmlAttributeValue && SpringSecuritySpElAccessInjector.ACCESS_ATTR_PATTERN.accepts((Object)context);
    }
}

