/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.ELImplicitVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityELVariablesProvider
extends ElVariablesProvider {
    private static final String LAST_EXCEPTION = "SPRING_SECURITY_LAST_EXCEPTION";
    private static final String LAST_USERNAME = "SPRING_SECURITY_LAST_USERNAME";

    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder expressionHolder, @NotNull ELElementProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/el/SpringSecurityELVariablesProvider", "processImplicitVariables"));
        }
        if (expressionHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/spring/security/el/SpringSecurityELVariablesProvider", "processImplicitVariables"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/security/el/SpringSecurityELVariablesProvider", "processImplicitVariables"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!(containingFile instanceof JspFile)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        PsiClass springSecurityClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.core.Authentication");
        if (springSecurityClass == null) {
            return true;
        }
        GlobalSearchScope scope = element.getResolveScope();
        if (!processor.processVariable((PsiVariable)SpringSecurityELVariablesProvider.createVariable(element, LAST_EXCEPTION, (PsiType)PsiType.getJavaLangThrowable((PsiManager)element.getManager(), (GlobalSearchScope)scope)))) {
            return false;
        }
        return processor.processVariable((PsiVariable)SpringSecurityELVariablesProvider.createVariable(element, LAST_USERNAME, (PsiType)PsiType.getJavaLangString((PsiManager)element.getManager(), (GlobalSearchScope)scope)));
    }

    private static JspImplicitVariable createVariable(PsiElement element, String name, PsiType type) {
        return new ELImplicitVariable(element, name, type, null, "NESTED"){

            @Nullable
            public Icon getIcon(boolean open) {
                return SpringApiIcons.Spring;
            }

            @Nullable
            public String getLocationString() {
                return "Spring Security";
            }
        };
    }
}

