/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.graph.StrutsDataModel;
import com.intellij.struts2.graph.StrutsPresentationModel;
import com.intellij.struts2.graph.beans.BasicStrutsEdge;
import com.intellij.struts2.graph.beans.BasicStrutsNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Struts2GraphComponent
extends JPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String STRUTS2_DESIGNER_COMPONENT = "STRUTS2_DESIGNER_COMPONENT";
    private final GraphBuilder<BasicStrutsNode, BasicStrutsEdge> myBuilder;

    public Struts2GraphComponent(XmlFile xmlFile) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setText("Initializing...");
        Project project = xmlFile.getProject();
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
        progress.setText("Building model...");
        StrutsDataModel myDataModel = new StrutsDataModel(xmlFile);
        StrutsPresentationModel presentationModel = new StrutsPresentationModel(graph);
        progress.setText("Setup graph...");
        this.myBuilder = GraphBuilderFactory.getInstance((Project)project).createGraphBuilder(graph, view, (GraphDataModel)myDataModel, (GraphPresentationModel)presentationModel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbarPanel(), "North");
        this.add((Component)this.myBuilder.getView().getJComponent(), "Center");
        Disposer.register((Disposable)this, this.myBuilder);
        this.myBuilder.initialize();
        DomManager.getDomManager((Project)this.myBuilder.getProject()).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                if (Struts2GraphComponent.this.isShowing()) {
                    Struts2GraphComponent.this.myBuilder.queueUpdate();
                }
            }
        }, (Disposable)this);
    }

    private JComponent createToolbarPanel() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)GraphViewUtil.getBasicToolbar(this.myBuilder));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, true);
        return actionToolbar.getComponent();
    }

    public List<DomElement> getSelectedDomElements() {
        ArrayList<DomElement> selected = new ArrayList<DomElement>();
        Graph2D graph = this.myBuilder.getGraph();
        for (Node node : graph.getNodeArray()) {
            BasicStrutsNode nodeObject;
            if (!graph.isSelected(node) || (nodeObject = (BasicStrutsNode)this.myBuilder.getNodeObject(node)) == null) continue;
            ContainerUtil.addIfNotNull(nodeObject.getIdentifyingElement(), selected);
        }
        return selected;
    }

    public void setSelectedDomElement(DomElement domElement) {
    }

    public GraphBuilder getBuilder() {
        return this.myBuilder;
    }

    public Overview getOverview() {
        return GraphManager.getGraphManager().createOverview(this.myBuilder.getView());
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (Comparing.equal((String)dataId, (String)STRUTS2_DESIGNER_COMPONENT)) {
            return this;
        }
        return null;
    }
}

