/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.MockFileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public abstract class FileTypeManager
extends FileTypeRegistry {
    private static FileTypeManager ourInstance;
    @NotNull
    public static final Topic<FileTypeListener> TOPIC;

    public static FileTypeManager getInstance() {
        FileTypeManager instance = ourInstance;
        if (instance == null) {
            Application app = ApplicationManager.getApplication();
            instance = app != null ? app.getComponent(FileTypeManager.class) : new MockFileTypeManager();
            ourInstance = instance;
        }
        return instance;
    }

    public abstract void registerFileType(@NotNull FileType var1, @NotNull List<FileNameMatcher> var2);

    public final void registerFileType(@NotNull FileType type, String ... defaultAssociatedExtensions) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/FileTypeManager", "registerFileType"));
        }
        ArrayList<FileNameMatcher> matchers = new ArrayList<FileNameMatcher>();
        if (defaultAssociatedExtensions != null) {
            for (String extension : defaultAssociatedExtensions) {
                matchers.add(new ExtensionFileNameMatcher(extension));
            }
        }
        this.registerFileType(type, matchers);
    }

    public abstract boolean isFileIgnored(@NonNls @NotNull String var1);

    @NotNull
    public abstract String[] getAssociatedExtensions(@NotNull FileType var1);

    @NotNull
    public abstract List<FileNameMatcher> getAssociations(@NotNull FileType var1);

    public abstract boolean isFileOfType(@NotNull VirtualFile var1, @NotNull FileType var2);

    public abstract void addFileTypeListener(@NotNull FileTypeListener var1);

    public abstract void removeFileTypeListener(@NotNull FileTypeListener var1);

    @Deprecated
    @Nullable
    public abstract FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile var1);

    @Nullable
    public abstract FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile var1, @NotNull Project var2);

    @NotNull
    public abstract String getIgnoredFilesList();

    public abstract void setIgnoredFilesList(@NotNull String var1);

    public final void associateExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/FileTypeManager", "associateExtension"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/FileTypeManager", "associateExtension"));
        }
        this.associate(type, new ExtensionFileNameMatcher(extension));
    }

    public final void associatePattern(@NotNull FileType type, @NotNull @NonNls String pattern) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/FileTypeManager", "associatePattern"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/openapi/fileTypes/FileTypeManager", "associatePattern"));
        }
        this.associate(type, FileTypeManager.parseFromString(pattern));
    }

    public abstract void associate(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    public final void removeAssociatedExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/FileTypeManager", "removeAssociatedExtension"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/FileTypeManager", "removeAssociatedExtension"));
        }
        this.removeAssociation(type, new ExtensionFileNameMatcher(extension));
    }

    public abstract void removeAssociation(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    @NotNull
    public static FileNameMatcher parseFromString(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/openapi/fileTypes/FileTypeManager", "parseFromString"));
        }
        FileNameMatcher fileNameMatcher = FileNameMatcherFactory.getInstance().createMatcher(pattern);
        if (fileNameMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeManager", "parseFromString"));
        }
        return fileNameMatcher;
    }

    @NotNull
    public abstract FileType getStdFileType(@NotNull @NonNls String var1);

    static {
        FileTypeRegistry.ourInstanceGetter = () -> FileTypeManager.getInstance();
        ourInstance = CachedSingletonsRegistry.markCachedField(FileTypeManager.class);
        TOPIC = new Topic("File types change", FileTypeListener.class);
    }
}

