/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import org.jetbrains.annotations.NotNull;

public class CompositeComponentAttributeDescriptor
implements XmlAttributeDescriptor {
    private XmlTag myXmlTag;

    public CompositeComponentAttributeDescriptor(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/jsf/composite/CompositeComponentAttributeDescriptor", "<init>"));
        }
        this.myXmlTag = xmlTag;
    }

    public boolean isRequired() {
        return Boolean.valueOf(this.myXmlTag.getAttributeValue("required"));
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    public String getDefaultValue() {
        return this.myXmlTag.getAttributeValue("default");
    }

    public boolean isEnumerated() {
        return false;
    }

    public String[] getEnumeratedValues() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String validateValue(XmlElement context, String value) {
        return null;
    }

    public PsiElement getDeclaration() {
        XmlAttribute attribute = this.myXmlTag.getAttribute("name");
        return attribute == null ? null : attribute.getValueElement();
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myXmlTag.getAttributeValue("name");
    }

    public void init(PsiElement element) {
    }

    public Object[] getDependences() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public PsiType getType() {
        String value = this.myXmlTag.getAttributeValue("type");
        if (value != null) {
            PsiType psiType;
            try {
                psiType = JavaPsiFacade.getElementFactory((Project)this.myXmlTag.getProject()).createTypeFromText(value, (PsiElement)this.myXmlTag);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeComponentAttributeDescriptor", "getType"));
            }
            return psiType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeComponentAttributeDescriptor", "getType"));
        }
        return psiPrimitiveType;
    }
}

