/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.converters.model;

import com.intellij.codeInsight.lookup.LookupValueFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jsf.model.xml.managedBeans.ManagedProperty;
import com.intellij.jsf.model.xml.managedBeans.PropertyBean;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManagedPropertyNameConverter
extends Converter<Set<BeanProperty>>
implements CustomReferenceConverter<Set<BeanProperty>> {
    public Set<BeanProperty> fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass psiClass = ManagedPropertyNameConverter.getManagedBeanClass(context);
        if (psiClass != null) {
            HashSet propertySet = new HashSet();
            List setters = PropertyUtil.getSetters((PsiClass)psiClass, (String)s);
            PsiType expectedType = JsfCommonUtils.getManagedPropertyExpectedType(ManagedPropertyNameConverter.getManagedProperty(context));
            for (PsiMethod psiMethod : setters) {
                PsiType type = PropertyUtil.getPropertyType((PsiMember)psiMethod);
                if (expectedType != null && (type == null || !type.isAssignableFrom(expectedType))) continue;
                propertySet.add(BeanProperty.createBeanProperty((PsiMethod)psiMethod));
            }
            return propertySet;
        }
        return null;
    }

    @Nullable
    private static PsiClass getManagedBeanClass(ConvertContext context) {
        PropertyBean managedBean = ManagedPropertyNameConverter.getManagedBean(context);
        if (managedBean != null) {
            return (PsiClass)managedBean.getManagedBeanClass().getValue();
        }
        return null;
    }

    @Nullable
    private static PropertyBean getManagedBean(ConvertContext context) {
        return (PropertyBean)context.getInvocationElement().getParentOfType(PropertyBean.class, false);
    }

    @Nullable
    private static ManagedProperty getManagedProperty(ConvertContext context) {
        return (ManagedProperty)context.getInvocationElement().getParentOfType(ManagedProperty.class, false);
    }

    public String toString(@Nullable Set<BeanProperty> beanPropertySet, ConvertContext context) {
        return beanPropertySet == null || beanPropertySet.size() == 0 ? null : PropertyUtil.getPropertyNameBySetter((PsiMethod)beanPropertySet.iterator().next().getMethod());
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<Set<BeanProperty>> value, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new MyPsiReferenceBase(element, value, ManagedPropertyNameConverter.getManagedBean(context), ManagedPropertyNameConverter.getManagedBeanClass(context), JsfCommonUtils.getManagedPropertyExpectedType(ManagedPropertyNameConverter.getManagedProperty(context)))};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/converters/model/ManagedPropertyNameConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static List<BeanProperty> getUndefinedProperties(@Nullable PropertyBean propertyBean, @Nullable PsiClass componentClass, PsiType managedPropertyExpectedType) {
        ArrayList<BeanProperty> properties = new ArrayList<BeanProperty>();
        if (propertyBean != null && componentClass != null) {
            List alreadyDefinedProperties = ContainerUtil.mapNotNull(propertyBean.getManagedProperties(), managedProperty -> managedProperty.getPropertyName().getStringValue());
            Map map = PropertyUtil.getAllProperties((PsiClass)componentClass, (boolean)true, (boolean)false);
            for (String propertyName : map.keySet()) {
                if (alreadyDefinedProperties.contains(propertyName)) continue;
                PsiMethod method = (PsiMethod)map.get(propertyName);
                PsiType type = PropertyUtil.getPropertyType((PsiMember)method);
                if (managedPropertyExpectedType != null && (type == null || !type.isAssignableFrom(managedPropertyExpectedType))) continue;
                properties.add(BeanProperty.createBeanProperty((PsiMethod)method));
            }
        }
        return properties;
    }

    @Nullable
    private static PsiType getLangObjectType(Project project) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = psiFacade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project));
        return psiClass == null ? null : psiFacade.getElementFactory().createType(psiClass);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return FacesBundle.message("ManagedPropertyNameConverter.cannot.find.property", s);
    }

    private static class MyPsiReferenceBase
    extends PsiReferenceBase<PsiElement>
    implements PsiPolyVariantReference,
    LocalQuickFixProvider {
        private final GenericDomValue<Set<BeanProperty>> myGenericDomValue;
        @Nullable
        private final PropertyBean myManagedBean;
        @Nullable
        private final PsiClass myManagedBeanClass;
        @Nullable
        private final PsiType myManagedPropertyExpectedType;

        public MyPsiReferenceBase(PsiElement element, GenericDomValue<Set<BeanProperty>> genericDomValue, @Nullable PropertyBean managedBean, @Nullable PsiClass managedBeanClass, @Nullable PsiType managedPropertyExpectedType) {
            super(element, true);
            this.myGenericDomValue = genericDomValue;
            this.myManagedBean = managedBean;
            this.myManagedBeanClass = managedBeanClass;
            this.myManagedPropertyExpectedType = managedPropertyExpectedType;
        }

        public PsiElement resolve() {
            Set value = (Set)this.myGenericDomValue.getValue();
            return value != null && value.size() == 1 ? ((BeanProperty)value.iterator().next()).getMethod() : null;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            String name = PropertyUtil.getPropertyName((String)newElementName);
            return super.handleElementRename(name == null ? newElementName : name);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String propertyName;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/converters/model/ManagedPropertyNameConverter$MyPsiReferenceBase", "bindToElement"));
            }
            if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
                return super.handleElementRename(propertyName);
            }
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ContainerUtil.map2Array((Collection)ManagedPropertyNameConverter.getUndefinedProperties(this.myManagedBean, this.myManagedBeanClass, this.myManagedPropertyExpectedType), beanProperty -> LookupValueFactory.createLookupValueWithHint((String)beanProperty.getName(), (Icon)beanProperty.getIcon(0), (String)beanProperty.getPropertyType().getPresentableText()));
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/converters/model/ManagedPropertyNameConverter$MyPsiReferenceBase", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            Set beanProperties = (Set)this.myGenericDomValue.getValue();
            if (beanProperties == null || beanProperties.size() == 0) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/converters/model/ManagedPropertyNameConverter$MyPsiReferenceBase", "multiResolve"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array((Collection)beanProperties, (Object[])new ResolveResult[0], beanProperty -> new PsiElementResolveResult((PsiElement)beanProperty.getMethod()));
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/converters/model/ManagedPropertyNameConverter$MyPsiReferenceBase", "multiResolve"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes() {
            String value = this.getValue();
            if (StringUtil.isNotEmpty((String)value) && this.myManagedBeanClass != null) {
                PsiType psiType;
                PsiType psiType2 = psiType = this.myManagedPropertyExpectedType == null ? ManagedPropertyNameConverter.getLangObjectType(this.myManagedBeanClass.getProject()) : this.myManagedPropertyExpectedType;
                if (psiType != null) {
                    return CreateBeanPropertyFix.createFixes((String)value, (PsiClass)this.myManagedBeanClass, (PsiType)psiType, (boolean)true);
                }
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }
}

