/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.jsf.JsfProjectComponent;
import com.intellij.jsf.toolWindow.tree.JsfTreeStructure;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.ComponentsNode;
import com.intellij.jsf.toolWindow.tree.nodes.ConvertersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfTreeRootNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfViewSettings;
import com.intellij.jsf.toolWindow.tree.nodes.ListenersNode;
import com.intellij.jsf.toolWindow.tree.nodes.ManagedBeansNode;
import com.intellij.jsf.toolWindow.tree.nodes.RenderersNode;
import com.intellij.jsf.toolWindow.tree.nodes.ValidatorsNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.JsfIcons;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JsfModuleNode
extends SimpleNode {
    private Module myModule;
    private JsfTreeStructure myTreeStructure;

    public JsfModuleNode(@NotNull Module module, JsfTreeStructure treeStructure, JsfTreeRootNode jsfTreeRootNode) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/toolWindow/tree/nodes/JsfModuleNode", "<init>"));
        }
        super((SimpleNode)jsfTreeRootNode);
        this.myModule = module;
        this.myTreeStructure = treeStructure;
        this.setUniformIcon(JsfIcons.Module);
    }

    protected void doUpdate() {
        this.setPlainText(this.myModule.getName());
    }

    public SimpleNode[] getChildren() {
        ArrayList<AbstractJsfTypeNode> children = new ArrayList<AbstractJsfTypeNode>();
        JsfViewSettings settings = JsfProjectComponent.getInstance((Project)this.myModule.getProject()).getState().viewSettings;
        boolean showFromLibraries = settings.libraries;
        if (settings.managed_beans) {
            children.add(new ManagedBeansNode(this.myModule, this, showFromLibraries));
        }
        if (settings.converter) {
            children.add(new ConvertersNode(this.myModule, this, showFromLibraries));
        }
        if (settings.component) {
            children.add(new ComponentsNode(this.myModule, this, showFromLibraries));
        }
        if (settings.renderer) {
            children.add(new RenderersNode(this.myModule, this, showFromLibraries));
        }
        if (settings.validator) {
            children.add(new ValidatorsNode(this.myModule, this, showFromLibraries));
        }
        if (settings.listener_for) {
            children.add(new ListenersNode(this.myModule, this, showFromLibraries));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myModule};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/JsfModuleNode", "getEqualityObjects"));
        }
        return objectArray;
    }
}

