/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.ArgNamesManipulator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SetArgNamesQuickFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.aop.jam.SetArgNamesQuickFix");
    private final String myName;
    private final boolean mySet;
    private final ArgNamesManipulator myManipulator;
    private final PsiMethod myMethod;

    public SetArgNamesQuickFix(String name, boolean set, ArgNamesManipulator manipulator, PsiMethod method) {
        this.myName = name;
        this.mySet = set;
        this.myManipulator = manipulator;
        this.myMethod = method;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/aop/jam/SetArgNamesQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/aop/jam/SetArgNamesQuickFix", "applyFix"));
        }
        try {
            CheckUtil.checkWritable((PsiElement)descriptor.getPsiElement());
            if (this.mySet) {
                PsiMethod method = this.myMethod;
                StringBuilder result = new StringBuilder();
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    String name = parameter.getName();
                    if (result.length() > 0) {
                        result.append(",");
                    }
                    result.append(name);
                }
                this.myManipulator.setArgNames(result.toString());
            } else {
                this.myManipulator.setArgNames(null);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/SetArgNamesQuickFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/SetArgNamesQuickFix", "getName"));
        }
        return string;
    }
}

