/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.freemarker;

import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlGlobalVariableProvider;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jsp.SpringModelELVariable;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcFtlGlobalVariableProvider
extends FtlGlobalVariableProvider {
    @NotNull
    public List<? extends FtlVariable> getGlobalVariables(FtlFile file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        SpringMVCModel model = SpringMVCModel.getModel((PsiElement)file);
        if (model == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider", "getGlobalVariables"));
            }
            return list;
        }
        SmartList result = new SmartList();
        Processor collectProcessor = arg_0 -> SpringMvcFtlGlobalVariableProvider.lambda$getGlobalVariables$0((List)result, file, arg_0);
        model.processVariables((PsiElement)file, (Processor<PsiVariable>)collectProcessor);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider", "getGlobalVariables"));
        }
        return smartList;
    }

    private static /* synthetic */ boolean lambda$getGlobalVariables$0(List result, FtlFile file, PsiVariable variable) {
        String name = variable.getName();
        PsiClass variableClass = PsiTypesUtil.getPsiClass((PsiType)variable.getType());
        if (name != null && variableClass != null && variableClass.getQualifiedName() != null) {
            result.add(new ModelAttributeFtlVariable((PsiFile)file, variable));
        }
        return true;
    }

    private static class ModelAttributeFtlVariable
    extends RenameableFakePsiElement
    implements FtlVariable {
        private final PsiFile myParent;
        private final PsiVariable myVariable;

        private ModelAttributeFtlVariable(PsiFile parent, PsiVariable variable) {
            super((PsiElement)variable);
            this.myParent = parent;
            this.myVariable = variable;
        }

        @Nullable
        public String getLocationString() {
            return ((SpringModelELVariable)this.myVariable).getLocationString();
        }

        public PsiFile getContainingFile() {
            return this.myParent;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myVariable.getNavigationElement();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider$ModelAttributeFtlVariable", "getNavigationElement"));
            }
            return psiElement;
        }

        public PsiElement getDeclaration() {
            return this;
        }

        @Nullable
        public FtlType getType() {
            return FtlPsiType.wrap((PsiType)this.myVariable.getType());
        }

        public String getName() {
            return this.myVariable.getName();
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/web/mvc/freemarker/SpringMvcFtlGlobalVariableProvider$ModelAttributeFtlVariable", "setName"));
            }
            this.myVariable.setName(name);
            return this;
        }

        public String getTypeName() {
            return "Model attribute";
        }

        @Nullable
        public Icon getIcon() {
            return PlatformIcons.VARIABLE_ICON;
        }
    }
}

