/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMVCInitBinderInspection
extends BaseJavaLocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/web/mvc/jam/SpringMVCInitBinderInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/web/mvc/jam/SpringMVCInitBinderInspection", "checkMethod"));
        }
        if (!SpringMVCInitBinderInspection.isRelevantMethod(method)) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        SpringControllerClassInfo info = SpringControllerClassInfo.getInfo(containingClass);
        if (!info.isController()) {
            return null;
        }
        PsiAnnotation annotation = method.getModifierList().findAnnotation("org.springframework.web.bind.annotation.InitBinder");
        assert (annotation != null);
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)annotation, "Method annotated with @InitBinder must return void", (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly)};
    }

    private static boolean isRelevantMethod(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.hasModifierProperty("static") && !PsiType.VOID.equals((Object)method.getReturnType()) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.web.bind.annotation.InitBinder", (boolean)false);
    }
}

