/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.navigation;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import icons.SpringMvcIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoSpringRequestMappingSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "addNames"));
        }
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, (Processor<SpringMVCModel>)((Processor)model -> {
            List<SpringMVCModel.Variant> urls = model.getAllUrls();
            for (SpringMVCModel.Variant variant : urls) {
                result.add("/" + variant.presentation);
            }
            return true;
        }));
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "addItems"));
        }
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'/')) {
            return;
        }
        String nameWithoutPrefix = name.substring(1);
        GotoSpringRequestMappingSymbolProvider.processSpringMvcModel(module, (Processor<SpringMVCModel>)((Processor)model -> {
            for (final SpringMVCModel.Variant variant : model.getAllUrls()) {
                PsiElement target;
                if (!nameWithoutPrefix.equals(variant.presentation) || (target = variant.psiElementPointer.getPsiElement()) == null) continue;
                result.add((NavigationItem)new GoToSymbolProvider.BaseNavigationItem(target, "/" + variant.presentation, SpringMvcIcons.RequestMapping){

                    public ItemPresentation getPresentation() {
                        final ItemPresentation original = super.getPresentation();
                        assert (original != null);
                        return new ItemPresentation(){

                            public String getPresentableText() {
                                return original.getPresentableText();
                            }

                            @Nullable
                            public String getLocationString() {
                                String requestMethods = variant.method.length != 0 ? " " + RequestMethod.getDisplay(variant.method) : "";
                                return original.getLocationString() + requestMethods;
                            }

                            @Nullable
                            public Icon getIcon(boolean open) {
                                return original.getIcon(open);
                            }
                        };
                    }
                });
            }
            return true;
        }));
    }

    protected boolean acceptModule(Module module) {
        return SpringFacet.getInstance((Module)module) != null && !WebFacet.getInstances((Module)module).isEmpty() && SpringMvcLibraryUtil.hasSpringMvcLibrary(module);
    }

    private static void processSpringMvcModel(@NotNull Module module, Processor<SpringMVCModel> modelProcessor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/navigation/GotoSpringRequestMappingSymbolProvider", "processSpringMvcModel"));
        }
        SpringFacet springFacet = (SpringFacet)ObjectUtils.assertNotNull((Object)SpringFacet.getInstance((Module)module));
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            SpringMVCModel springMvcModel = SpringMVCModel.getModel(webFacet, springFacet);
            if (springMvcModel == null) continue;
            modelProcessor.process((Object)springMvcModel);
        }
    }
}

