/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.web.mvc.tiles.TilesViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.spring.web.mvc.views.ViewResolverFactory;
import java.util.Collections;
import java.util.Set;

public class TilesViewResolverFactory
extends ViewResolverFactory {
    @Override
    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        if (TilesViewResolverFactory.isTilesViewClass(beanClass)) {
            return true;
        }
        String viewClassValue = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"viewClass");
        if (viewClassValue == null) {
            return false;
        }
        if ("org.springframework.web.servlet.view.tiles2.TilesView".equals(viewClassValue) || "org.springframework.web.servlet.view.tiles3.TilesView".equals(viewClassValue)) {
            return true;
        }
        Module module = bean.getModule();
        if (module == null) {
            return false;
        }
        return TilesViewResolverFactory.isTilesViewClass(SpringCommonUtils.findLibraryClass((Module)module, (String)viewClassValue));
    }

    @Override
    public String getBeanClass() {
        return null;
    }

    @Override
    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        return Collections.singleton(new TilesViewResolver(model));
    }

    private static boolean isTilesViewClass(PsiClass psiClass) {
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles2.TilesView") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.web.servlet.view.tiles3.TilesView");
    }
}

