/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileReference
extends FileReference
implements JSModuleBaseReference {
    public static final String[] IMPLICIT_EXTENSIONS = new String[]{".coffee", ".d.ts", ".d.tsx", ".ts", ".tsx", ".jsx", ".es6", ".js"};
    public static final String PACKAGE_JSON = "package.json";
    private final String[] myImplicitExtensions;

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSFileReference", "<init>"));
        }
        this(text, offset, textRange, fileReferenceSet, IMPLICIT_EXTENSIONS);
    }

    public JSFileReference(String text, int offset, TextRange textRange, @NotNull FileReferenceSet fileReferenceSet, String[] implicitExtensions) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/intellij/javascript/JSFileReference", "<init>"));
        }
        super(fileReferenceSet, textRange, offset, text);
        this.myImplicitExtensions = implicitExtensions;
    }

    protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/javascript/JSFileReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSFileReference", "innerResolveInContext"));
        }
        if (!this.isLast()) {
            super.innerResolveInContext(referenceText, context, results, caseSensitive);
            return;
        }
        if (referenceText.isEmpty() && !this.getFileReferenceSet().isEndingSlashNotAllowed()) {
            super.innerResolveInContext(referenceText, context, results, caseSensitive);
            return;
        }
        int size = results.size();
        for (String extension : this.myImplicitExtensions) {
            if (size != results.size() || referenceText.endsWith(extension)) continue;
            super.innerResolveInContext(referenceText + extension, context, results, caseSensitive);
        }
        if (size == results.size()) {
            super.innerResolveInContext(referenceText, context, results, caseSensitive);
            Iterator<ResolveResult> iterator = results.iterator();
            while (iterator.hasNext() && size > 0) {
                iterator.next();
                --size;
            }
            this.processDirectoriesFromCurrentIterator(iterator, results);
        }
    }

    protected void processDirectoriesFromCurrentIterator(Iterator<ResolveResult> iterator, Collection<ResolveResult> results) {
        if (!this.isAllowFolders()) {
            while (iterator.hasNext()) {
                ResolveResult result = iterator.next();
                if (!(result.getElement() instanceof PsiDirectory)) continue;
                iterator.remove();
            }
        }
    }

    protected boolean isAllowFolders() {
        return false;
    }

    @NotNull
    public String getFileNameToCreate() {
        VirtualFile vFile;
        PsiFile psiFile;
        String text = this.getText();
        if (!StringUtil.containsChar((String)text, (char)'.') && this.isLast() && (psiFile = this.getElement().getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
            String string = text + "." + vFile.getExtension();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getFileNameToCreate"));
            }
            return string;
        }
        String string = super.getFileNameToCreate();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSFileReference", "getFileNameToCreate"));
        }
        return string;
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        if (!this.isLast()) {
            newName = this.fixRelativePath(newName);
            return super.rename(newName);
        }
        newName = this.fixExtension(newName);
        newName = this.fixRelativePath(newName);
        return super.rename(newName);
    }

    private String fixRelativePath(String newName) {
        FileReference reference;
        String refText;
        if (!this.getFileReferenceSet().isAbsolutePathReference() && (".".equals(refText = (reference = this.getFileReferenceSet().getReference(0)).getText()) || refText != null && refText.startsWith("..")) && !newName.startsWith("..")) {
            newName = "./" + newName;
        }
        return newName;
    }

    protected String fixExtension(String newName) {
        return this.fixExtension(newName, this.getText());
    }

    protected String fixExtension(String newName, String oldRefText) {
        String newImplicitExtension = JSFileReference.findImplicitExtension(newName);
        String textImplicitExtension = JSFileReference.findImplicitExtension(oldRefText);
        if (newImplicitExtension != null && textImplicitExtension == null || oldRefText.indexOf(46) == -1) {
            int indexNameWithoutExtension;
            int n = indexNameWithoutExtension = newImplicitExtension != null ? newName.length() - newImplicitExtension.length() : newName.lastIndexOf(46);
            if (indexNameWithoutExtension != -1) {
                newName = newName.substring(0, indexNameWithoutExtension);
            }
        }
        return newName;
    }

    protected PsiElement fixRefText(String name) {
        return super.fixRefText(this.fixExtension(name));
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "bindToElement"));
        }
        if (!this.isRelativeCommonPath() && JSFileReference.checkReferencedFileFromNodeModules(element)) {
            return this.getElement();
        }
        return super.bindToElement(element, absolute);
    }

    private boolean isRelativeCommonPath() {
        String path = this.getFileReferenceSet().getPathString();
        return path.startsWith(".");
    }

    private static boolean checkReferencedFileFromNodeModules(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSFileReference", "checkReferencedFileFromNodeModules"));
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && JSLibraryUtil.hasDirectoryInPath(file, "node_modules", null);
    }

    @Contract(value="null, _ -> null")
    public static String findExtension(@Nullable String fileName, String[] extensions) {
        if (fileName == null) {
            return null;
        }
        for (String extension : extensions) {
            if (!StringUtil.endsWithIgnoreCase((String)fileName, (String)extension)) continue;
            return extension;
        }
        return null;
    }

    @Contract(value="null -> null")
    public static String findImplicitExtension(@Nullable String fileName) {
        return JSFileReference.findExtension(fileName, IMPLICIT_EXTENSIONS);
    }
}

