/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.util.JsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageVersionUtil {
    private static final Logger LOG = Logger.getInstance(NodePackageVersionUtil.class);
    private static final Map<String, TimestampedVersion> PACKAGE_VERSION_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, TimestampedVersion>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TimestampedVersion> eldest) {
            return this.size() > 10;
        }
    });

    @Nullable
    public static NodePackageVersion getPackageVersion(@NotNull String packageDirPath) {
        if (packageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDirPath", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "getPackageVersion"));
        }
        return NodePackageVersionUtil.getPackageVersionByPackageJson(new File(packageDirPath, "package.json"));
    }

    @Nullable
    public static SemVer getPackageVersion(@NotNull File packageDir) {
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "getPackageVersion"));
        }
        NodePackageVersion packageVersion = NodePackageVersionUtil.getPackageVersionByPackageJson(new File(packageDir, "package.json"));
        return packageVersion != null ? packageVersion.getSemVer() : null;
    }

    @Nullable
    private static NodePackageVersion getPackageVersionByPackageJson(@NotNull File packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "getPackageVersionByPackageJson"));
        }
        if (!packageJson.isFile()) {
            return null;
        }
        long lastModified = packageJson.lastModified();
        String path = packageJson.getAbsolutePath();
        TimestampedVersion r = PACKAGE_VERSION_CACHE.get(path);
        if (r == null || r.getTimestamp() != lastModified) {
            NodePackageVersion packageVersion = NodePackageVersionUtil.calc(packageJson);
            r = new TimestampedVersion(lastModified, packageVersion);
            PACKAGE_VERSION_CACHE.put(path, r);
        }
        return r.getPackageVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NodePackageVersion calc(@NotNull File packageJson) {
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "calc"));
        }
        JsonReader jsonReader = null;
        try {
            BufferedReader reader = Files.newReader((File)packageJson, (Charset)Charsets.UTF_8);
            jsonReader = new JsonReader((Reader)reader);
            NodePackageVersion nodePackageVersion = NodePackageVersionUtil.parseNodePackageVersion(jsonReader);
            return nodePackageVersion;
        }
        catch (IOException e) {
            LOG.warn("Failed to parse " + packageJson.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Nullable
    private static NodePackageVersion parseNodePackageVersion(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "parseNodePackageVersion"));
        }
        JsonToken token = reader.peek();
        if (token != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        SemVer semVer = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("version".equals(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (value == null) continue;
                semVer = SemVer.parseFromText((String)value);
                continue;
            }
            if ("name".equals(key)) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return new NodePackageVersion(name, semVer);
    }

    public static int comparePackageVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version1", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "comparePackageVersions"));
        }
        if (version2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version2", "com/intellij/javascript/nodejs/NodePackageVersionUtil", "comparePackageVersions"));
        }
        if ((version1 = version1.trim()).equals(version2 = version2.trim())) {
            return 0;
        }
        SemVer ver1 = SemVer.parseFromText((String)version1);
        SemVer ver2 = SemVer.parseFromText((String)version2);
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int result = ver1.compareTo(ver2);
        if (result == 0) {
            if (version1.equals(ver1.getParsedVersion())) {
                return 1;
            }
            if (version2.equals(ver2.getParsedVersion())) {
                return -1;
            }
            result = PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
        }
        return result;
    }

    private static class TimestampedVersion {
        private final long myTimestamp;
        private final NodePackageVersion myPackageVersion;

        private TimestampedVersion(long timestamp, @Nullable NodePackageVersion packageVersion) {
            this.myTimestamp = timestamp;
            this.myPackageVersion = packageVersion;
        }

        public long getTimestamp() {
            return this.myTimestamp;
        }

        @Nullable
        public NodePackageVersion getPackageVersion() {
            return this.myPackageVersion;
        }
    }
}

