/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ES6FunctionParser<T extends ES6Parser>
extends FunctionParser<T> {
    public static final Key<Boolean> HAD_ASYNC_MODIFIER_KEY = Key.create((String)"js.asyncModifier");

    public ES6FunctionParser(T parser) {
        super(parser);
    }

    @Override
    public void parseFunctionExpressionAttributeList() {
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.EQGT) {
            this.parseAttributesList();
        }
    }

    @Override
    public boolean parseFunctionNoMarker(FunctionParser.Context context, @NotNull PsiBuilder.Marker functionMarker) {
        if (functionMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionMarker", "com/intellij/lang/ecmascript6/parsing/ES6FunctionParser", "parseFunctionNoMarker"));
        }
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        Boolean wasAsync = (Boolean)this.builder.getUserData(ASYNC_METHOD_KEY);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)isAsync);
        boolean result = super.parseFunctionNoMarker(context, functionMarker);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)wasAsync);
        return result;
    }

    @Override
    public boolean hasSupportDecorators() {
        return true;
    }

    @Override
    public boolean isFunctionDeclarationStart() {
        IElementType tokenType = this.builder.getTokenType();
        return tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
    }

    @Override
    public boolean parseAttributesList() {
        if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            return false;
        }
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean hadAttributes = this.tryParseES7Decorators();
        if (hadAttributes && ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).isExportDefault()) {
            modifierList.done(JSStubElementTypes.ATTRIBUTE_LIST);
            return true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD) {
            this.builder.advanceLexer();
            hadAttributes = true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
            hadAttributes = true;
        }
        if (hadAttributes) {
            modifierList.done(JSStubElementTypes.ATTRIBUTE_LIST);
        } else {
            modifierList.drop();
        }
        return true;
    }

    @Override
    public boolean parseArrowFunctionNoMarker(PsiBuilder.Marker arrowFunction) {
        this.parseFunctionExpressionAttributeList();
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        Boolean wasAsync = (Boolean)this.builder.getUserData(ASYNC_METHOD_KEY);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)isAsync);
        boolean result = super.parseArrowFunctionNoMarker(arrowFunction);
        this.builder.putUserData(ASYNC_METHOD_KEY, (Object)wasAsync);
        return result;
    }

    @Override
    protected boolean parseParameterListAndBody(PsiBuilder.Marker marker, IElementType elementType) {
        Boolean isAsync = (Boolean)this.builder.getUserData(HAD_ASYNC_MODIFIER_KEY);
        this.builder.putUserData(HAD_ASYNC_MODIFIER_KEY, null);
        Boolean wasAsync = (Boolean)this.builder.getUserData(FunctionParser.ASYNC_METHOD_KEY);
        this.builder.putUserData(FunctionParser.ASYNC_METHOD_KEY, (Object)isAsync);
        boolean lexerAdvanced = super.parseParameterListAndBody(marker, elementType);
        this.builder.putUserData(FunctionParser.ASYNC_METHOD_KEY, (Object)wasAsync);
        return lexerAdvanced;
    }

    @Override
    protected boolean hasParameterInitializers() {
        return true;
    }

    @Override
    protected boolean allowLastCommaInParameterAndArgumentList() {
        return true;
    }
}

