/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6TypeEvaluator
extends JSTypeEvaluator {
    public ES6TypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, boolean ecma) {
        super(context, processor, ecma);
    }

    @Override
    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        if (resolveResult instanceof ES6ExportSpecifierAlias) {
            if ((resolveResult = resolveResult.getParent()) instanceof ES6ExportSpecifier) {
                this.processItem((ES6ExportSpecifier)resolveResult, JSEvaluateContext.JSEvaluationPlace.DEFAULT, specifier -> {
                    ResolveResult[] exportSpecifierResults;
                    for (ResolveResult result : exportSpecifierResults = specifier.multiResolve(false)) {
                        PsiElement element;
                        if (!result.isValidResult() || (element = result.getElement()) == null) continue;
                        this.addTypeFromResolvedImport(element);
                    }
                });
            }
            return true;
        }
        if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            String type;
            PsiComment docComment;
            Collection referencedElements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            for (PsiElement referencedElement : referencedElements) {
                this.addTypeFromResolvedImport(referencedElement);
            }
            PsiElement parent = resolveResult.getParent();
            if (parent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)parent).getImportSpecifiers().length == 0 && (!DialectDetector.isTypeScript(parent) || referencedElements.size() == 0) && (docComment = JSDocumentationUtils.findDocComment(parent)) instanceof JSDocComment && (type = ((JSDocComment)docComment).getType()) != null) {
                this.addType(JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true)), resolveResult);
            }
            this.addTypeFromLocalName((PsiNamedElement)resolveResult);
            return true;
        }
        if (resolveResult instanceof ES6ImportSpecifierAlias) {
            this.addTypeFromES6ImportSpecifier((ES6ImportSpecifierAlias)resolveResult);
            return true;
        }
        return super.addTypeFromDialectSpecificElements(resolveResult);
    }

    private void addTypeFromES6ImportSpecifier(ES6ImportSpecifierAlias resolveResult) {
        PsiElement aliasedElement = resolveResult.findAliasedElement();
        if (aliasedElement != null) {
            this.processItem(aliasedElement, JSEvaluateContext.JSEvaluationPlace.DEFAULT, element -> this.addTypeFromResolveResult((PsiElement)element, false));
        }
        this.addTypeFromLocalName((PsiNamedElement)resolveResult);
    }

    private void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            PsiFile file = resolveResult.getContainingFile();
            this.myContext.withJSModule(file, () -> this.addNamespace(new JSNamespaceImpl(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, false), (PsiElement)resolveResult));
        }
    }

    protected void addTypeFromResolvedImport(PsiElement referencedElement) {
        if (referencedElement instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)referencedElement);
        } else if (referencedElement instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(referencedElement);
        } else if (referencedElement != null) {
            this.addTypeFromResolveResult(referencedElement, false);
        }
    }

    protected void evaluateExportAssignment(JSExportAssignment assignment) {
        JSExpression exportDefaultAssignmentExpression = assignment.getExpression();
        if (exportDefaultAssignmentExpression != null) {
            this.evaluateTypes(exportDefaultAssignmentExpression);
        }
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        if (rawqualifier instanceof JSClass) {
            this.addTypeFromClassExpression((JSClass)rawqualifier);
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    protected void addTypeFromClassExpression(@NotNull JSClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator", "addTypeFromClassExpression"));
        }
        String qualifiedName = aClass.getQualifiedName();
        boolean prototypeOrNewExpression = this.isPrototypeOrNewExpression();
        if (qualifiedName == null) {
            this.addType((JSType)TypeScriptTypeParser.buildTypeFromClass(aClass, true), (PsiElement)aClass);
            return;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)aClass, false);
        JSType jsType = JSNamedType.createType(qualifiedName, typeSource, prototypeOrNewExpression ? JSContext.INSTANCE : JSContext.STATIC);
        this.addType(jsType, (PsiElement)aClass);
    }

    protected boolean isPrototypeOrNewExpression() {
        return this.myContext.wasPrototypeReferenced() || this.myContext.peekJSElementToApply() instanceof JSNewExpression;
    }

    @Override
    protected void addTypeFromClass(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator", "addTypeFromClass"));
        }
        if (resolveResult instanceof ES6Class) {
            this.addTypeFromClassExpression((JSClass)((ES6Class)resolveResult));
        } else if (resolveResult instanceof JSFunction) {
            this.addTypeFromClass(resolveResult.getParent(), constructor);
        }
    }

    @Override
    protected void addModuleFromRequire(PsiElement module, JSCallExpression callExpression) {
        if (module instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)module);
        } else {
            super.addModuleFromRequire(module, callExpression);
        }
    }
}

