/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.parsing.JSParser;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.types.PsiGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class JavascriptParserDefinition
implements ParserDefinition {
    private static Function<ASTNode, PsiElement> ourGwtReferenceExpressionCreator;

    @NotNull
    public Lexer createLexer(Project project) {
        JSFlexAdapter jSFlexAdapter = new JSFlexAdapter(JavascriptLanguage.DIALECT_OPTION_HOLDER);
        if (jSFlexAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createLexer"));
        }
        return jSFlexAdapter;
    }

    public IFileElementType getFileNodeType() {
        return JSStubElementTypes.FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = JSTokenTypes.PARSER_WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = JSTokenTypes.COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = JSTokenTypes.STRING_LITERALS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        JSParser jSParser = new JSParser(null);
        if (jSParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createParser"));
        }
        return jSParser;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new JSFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (left instanceof PsiWhiteSpace) {
            return ParserDefinition.SpaceRequirements.MAY;
        }
        Lexer lexer = this.createLexer(left.getPsi().getProject());
        return LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
    }

    public static void setGwtReferenceExpressionCreator(Function<ASTNode, PsiElement> gwtReferenceExpressionCreator) {
        ourGwtReferenceExpressionCreator = gwtReferenceExpressionCreator;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement element;
        IElementType type = node.getElementType();
        if (type == JSElementTypes.XML_LITERAL_EXPRESSION) {
            if (!(node instanceof PsiElement)) {
                throw new AssertionError((Object)("Literal must be PsiElement but was: " + node + " (" + node.getClass() + ")"));
            }
            PsiElement psiElement = (PsiElement)node;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type instanceof PsiGenerator && (element = ((PsiGenerator)type).construct(node)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type == JSElementTypes.GWT_REFERENCE_EXPRESSION) {
            PsiElement psiElement = (PsiElement)ourGwtReferenceExpressionCreator.fun((Object)node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type == JSTokenTypes.XML_JS_SCRIPT) {
            JSEmbeddedContentImpl jSEmbeddedContentImpl = new JSEmbeddedContentImpl(node);
            if (jSEmbeddedContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
            }
            return jSEmbeddedContentImpl;
        }
        if (type == JSTokenTypes.DOC_COMMENT) {
            JSDocCommentImpl jSDocCommentImpl = new JSDocCommentImpl(node);
            if (jSDocCommentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
            }
            return jSDocCommentImpl;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JavascriptParserDefinition", "createElement"));
        }
        return aSTWrapperPsiElement;
    }
}

