/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsbtStartupActivity
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance(JsbtStartupActivity.class);

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "runActivity"));
        }
        NodeModulesDirectoryManager.getInstance(project).projectOpened();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        List servicesForDetection = ContainerUtil.newSmartList();
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(project);
            if (fileManager.hasBuildfiles()) {
                JsbtStartupActivity.setAvailable(project, service, Collections.emptyList());
                continue;
            }
            if (fileManager.isDetectionDone()) continue;
            fileManager.setDetectionDone();
            servicesForDetection.add(service);
            LOG.info("Detecting buildfiles for " + fileManager.getClass().getName());
        }
        if (!servicesForDetection.isEmpty()) {
            JsbtStartupActivity.scheduleDetection(project, servicesForDetection);
        }
    }

    private static void scheduleDetection(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "scheduleDetection"));
        }
        if (servicesForDetection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "scheduleDetection"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$scheduleDetection$2"));
            }
            if (servicesForDetection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$scheduleDetection$2"));
            }
            RefreshQueue.getInstance().refresh(true, true, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$null$1"));
                }
                if (servicesForDetection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$null$1"));
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$null$0"));
                    }
                    if (servicesForDetection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$null$0"));
                    }
                    JsbtStartupActivity.doDetect(project, servicesForDetection);
                });
            }, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance()));
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void doDetect(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "doDetect"));
        }
        if (servicesForDetection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "doDetect"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$doDetect$3"));
            }
            if (servicesForDetection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "servicesForDetection", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$doDetect$3"));
            }
            if (project.isDisposed()) {
                return;
            }
            for (JsbtService service : servicesForDetection) {
                List<VirtualFile> buildfiles = service.detectAllBuildfilesInContentRoots(project, true, true);
                LOG.info("Found " + buildfiles + " for " + service.getClass().getName());
                if (buildfiles.isEmpty()) continue;
                JsbtStartupActivity.setAvailable(project, service, buildfiles);
            }
        });
    }

    private static void setAvailable(@NotNull Project project, @NotNull JsbtService service, @NotNull List<VirtualFile> buildfilesToAdd) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        if (buildfilesToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfilesToAdd", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "setAvailable"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (buildfilesToAdd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfilesToAdd", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$setAvailable$4"));
            }
            if (service == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$setAvailable$4"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity", "lambda$setAvailable$4"));
            }
            for (VirtualFile buildfile : buildfilesToAdd) {
                service.getFileManager(project).addBuildfile(buildfile);
            }
            service.getToolWindowManager(project).setAvailable();
        });
    }
}

