/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.openapi.project.Project;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;

public class NpmConfigurationType
extends ConfigurationTypeBase {
    private static final String ID = "js.build_tools.npm";
    private static final String NAME = "npm";

    public NpmConfigurationType() {
        super(ID, NAME, NAME, JavaScriptLanguageIcons.BuildTools.Npm.Npm_16);
        this.addFactory((ConfigurationFactory)new ConfigurationFactoryEx<NpmRunConfiguration>((ConfigurationType)this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/rc/NpmConfigurationType$1", "createTemplateConfiguration"));
                }
                NpmRunConfiguration npmRunConfiguration = new NpmRunConfiguration(project, (ConfigurationFactory)this, NpmConfigurationType.NAME);
                if (npmRunConfiguration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmConfigurationType$1", "createTemplateConfiguration"));
                }
                return npmRunConfiguration;
            }

            public boolean isConfigurationSingletonByDefault() {
                return true;
            }

            public boolean canConfigurationBeSingleton() {
                return false;
            }

            public void onNewConfigurationCreated(@NotNull NpmRunConfiguration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/buildTools/npm/rc/NpmConfigurationType$1", "onNewConfigurationCreated"));
                }
                configuration.initializeFields();
            }
        });
    }

    @NotNull
    public static NpmConfigurationType getInstance() {
        NpmConfigurationType npmConfigurationType = (NpmConfigurationType)ConfigurationTypeUtil.findConfigurationType(NpmConfigurationType.class);
        if (npmConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmConfigurationType", "getInstance"));
        }
        return npmConfigurationType;
    }

    @NotNull
    public static ConfigurationFactory getFactory() {
        NpmConfigurationType type = NpmConfigurationType.getInstance();
        ConfigurationFactory configurationFactory = type.getConfigurationFactories()[0];
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/rc/NpmConfigurationType", "getFactory"));
        }
        return configurationFactory;
    }
}

