/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveHelper
implements JSResolveHelper {
    @Override
    @Nullable
    public PsiElement findClassByQName(String link, Project project, String className, GlobalSearchScope scope) {
        return null;
    }

    @Override
    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement file) {
        return true;
    }

    @Override
    public boolean processPackage(String packageQualifierText, String resolvedName, Processor<VirtualFile> processor, GlobalSearchScope globalSearchScope, Project project) {
        return true;
    }

    @Override
    public boolean isAdequatePlaceForImport(PsiElement place) {
        return false;
    }

    @Override
    public boolean resolveTypeNameUsingImports(ResolveProcessor processor, PsiNamedElement parent) {
        return true;
    }

    @Override
    public long getResolveResultTimestamp(PsiElement candidate) {
        return -1L;
    }

    @Override
    public JSReferenceExpression bindReferenceToElement(JSReferenceExpression ref, String name, String newName, boolean justMakeQualified, PsiNamedElement element) {
        if (DialectDetector.isTypeScript((PsiElement)element) && justMakeQualified && name != null && name.contains(".")) {
            ASTNode newChild = JSChangeUtil.createExpressionFromText(ref.getProject(), name);
            ref.getParent().getNode().replaceChild(ref.getNode(), newChild);
            ref = (JSReferenceExpression)newChild.getPsi();
        }
        return ref;
    }

    @Override
    public boolean isStrictTypeContext(PsiElement element) {
        return true;
    }

    public static boolean processGlobalThings(JSResolveProcessorBase processor, ResolveState state, @NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveHelper", "processGlobalThings"));
        }
        boolean result = true;
        String resolvedName = processor.getName();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(place);
        Project project = place.getProject();
        if (resolvedName == null) {
            PsiFile placeOriginalFile = place.getContainingFile().getOriginalFile();
            for (JSElement element : StubIndex.getElements(JSNamespaceMembersIndex.KEY, (Object)"", (Project)project, (GlobalSearchScope)scope, JSElement.class)) {
                PsiElement scopeElement;
                if (!(element instanceof JSQualifiedNamedElement) || !((scopeElement = JSPsiImplUtils.getExecutionScope((PsiElement)element)) instanceof PsiFile) || placeOriginalFile.equals(scopeElement)) continue;
                result &= processor.execute((PsiElement)element, state);
            }
        } else {
            Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(resolvedName, scope);
            for (JSQualifiedNamedElement element : elements) {
                if (!element.isNamespaceExplicitlyDeclared()) continue;
                processor.execute((PsiElement)element, state);
            }
        }
        return result;
    }
}

