/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.folding.JSCodeFoldingSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class JavaScriptFoldingBuilderBase
extends CustomFoldingBuilder {
    private static final int IMPORT_OFFSET = "import ".length();

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        this.appendDescriptors(root.getNode(), document, descriptors);
    }

    protected ASTNode appendDescriptors(ASTNode node, Document document, List<FoldingDescriptor> descriptors) {
        IElementType type = node.getElementType();
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type) || type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || type == JSElementTypes.ARRAY_LITERAL_EXPRESSION || type == JSElementTypes.XML_LITERAL_EXPRESSION || type == TypeScriptElementTypes.OBJECT_TYPE) {
            TextRange textRange = node.getTextRange();
            if (textRange.getEndOffset() <= document.getTextLength() && document.getLineNumber(textRange.getStartOffset()) != document.getLineNumber(textRange.getEndOffset())) {
                boolean skip = false;
                PsiElement parent = node.getTreeParent().getPsi();
                if (parent instanceof JSFunctionExpression && (parent = parent.getParent()) instanceof JSParenthesizedExpression) {
                    PsiElement currentParent = parent;
                    if ((parent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == currentParent && JavaScriptFoldingBuilderBase.isModulePattern(PsiTreeUtil.getParentOfType((PsiElement)parent, JSStatement.class))) {
                        skip = true;
                    }
                }
                if (!skip) {
                    JavaScriptFoldingBuilderBase.addDescriptorForNode(node, descriptors);
                }
            }
        } else if (type == JSElementTypes.SWITCH_STATEMENT) {
            TextRange textRange;
            ASTNode lBrace = node.findChildByType(JSTokenTypes.LBRACE);
            ASTNode rBrace = node.findChildByType(JSTokenTypes.RBRACE);
            if (lBrace != null && rBrace != null && (textRange = new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)).getEndOffset() < document.getTextLength() && document.getLineNumber(textRange.getStartOffset()) != document.getLineNumber(textRange.getEndOffset())) {
                JavaScriptFoldingBuilderBase.addDescriptorForRange(node, descriptors, textRange);
            }
        } else if (type == JSTokenTypes.DOC_COMMENT || type == JSTokenTypes.C_STYLE_COMMENT) {
            JavaScriptFoldingBuilderBase.addDescriptorForNode(node, descriptors);
        } else {
            ASTNode lbrace;
            if (type == JSTokenTypes.END_OF_LINE_COMMENT) {
                return JavaScriptFoldingBuilderBase.collapseConsequentNodesOfSpecifiedType(node, descriptors, JSTokenTypes.END_OF_LINE_COMMENT);
            }
            if (type == JSStubElementTypes.IMPORT_STATEMENT) {
                return JavaScriptFoldingBuilderBase.collapseConsequentNodesOfSpecifiedType(node, descriptors, type);
            }
            if (type == ES6ElementTypes.IMPORT_DECLARATION) {
                return JavaScriptFoldingBuilderBase.collapseES6Import(document, node, descriptors);
            }
            if ((type instanceof JSClassElementTypeBase || type == JSStubElementTypes.PACKAGE_STATEMENT || type == JSStubElementTypes.TYPESCRIPT_ENUM || type == JSStubElementTypes.TYPESCRIPT_MODULE) && (lbrace = node.findChildByType(JSTokenTypes.LBRACE)) != null) {
                JavaScriptFoldingBuilderBase.addDescriptorForRange(node, descriptors, new TextRange(lbrace.getStartOffset(), node.getTextRange().getEndOffset()));
            }
        }
        if (type instanceof JSFileElementType) {
            node.getPsi().getFirstChild();
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            IElementType iElementType = child.getElementType();
            if (iElementType == JSElementTypes.BINARY_EXPRESSION || iElementType == JSElementTypes.COMMA_EXPRESSION) {
                JSBinaryExpression expression = (JSBinaryExpression)child.getPsi();
                JSExpression lOperand = expression.getLOperand();
                while (JSSymbolUtil.binaryOpTypeToAvoidRecursions(expression.getOperationSign()) && lOperand instanceof JSBinaryExpression) {
                    ASTNode rOperandNode;
                    JSExpression rOperand = expression.getROperand();
                    ASTNode aSTNode = rOperandNode = rOperand != null ? rOperand.getNode() : null;
                    if (rOperandNode != null) {
                        this.appendDescriptors(rOperandNode, document, descriptors);
                    }
                    expression = (JSBinaryExpression)lOperand;
                    lOperand = expression.getLOperand();
                }
                this.appendDescriptors(expression.getNode(), document, descriptors);
                child = child.getTreeNext();
                continue;
            }
            child = this.appendDescriptors(child, document, descriptors).getTreeNext();
        }
        return node;
    }

    private static boolean isModulePattern(PsiElement element) {
        PsiElement sibling;
        if (element == null || !(element.getParent() instanceof JSFile)) {
            return false;
        }
        for (sibling = element.getNextSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            return false;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getPrevSibling()) {
        }
        return sibling == null;
    }

    private static void addDescriptorForRange(ASTNode node, List<FoldingDescriptor> descriptors, TextRange range) {
        if (range.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor(node, range);
            descriptor.setCanBeRemovedWhenCollapsed(JavaScriptFoldingBuilderBase.isImportNode(node.getElementType()));
            descriptors.add(descriptor);
        }
    }

    private static void addDescriptorForNode(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange range = node.getTextRange();
        JavaScriptFoldingBuilderBase.addDescriptorForRange(node, descriptors, range);
    }

    private static ASTNode collapseES6Import(Document document, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "collapseES6Import"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "collapseES6Import"));
        }
        int sizeBeforeCollapse = descriptors.size();
        ASTNode nodeResult = JavaScriptFoldingBuilderBase.collapseConsequentNodesOfSpecifiedType(node, descriptors, (IElementType)ES6ElementTypes.IMPORT_DECLARATION);
        if (descriptors.size() != sizeBeforeCollapse) {
            return nodeResult;
        }
        TextRange nodeRange = node.getTextRange();
        if (JavaScriptFoldingBuilderBase.isMultiline(document, node)) {
            JavaScriptFoldingBuilderBase.addDescriptorForRange(node, descriptors, new TextRange(nodeRange.getStartOffset() + IMPORT_OFFSET, nodeRange.getEndOffset()));
        }
        return node;
    }

    private static boolean isMultiline(Document document, ASTNode node) {
        TextRange nodeRange = node.getTextRange();
        int startNumber = document.getLineNumber(nodeRange.getStartOffset());
        int endNumber = document.getLineNumber(nodeRange.getEndOffset());
        return endNumber - startNumber > 0;
    }

    private static ASTNode collapseConsequentNodesOfSpecifiedType(ASTNode node, List<FoldingDescriptor> descriptors, IElementType nodeElementTypeToCollapse) {
        String text;
        PsiElement lastEoLComment = node.getPsi();
        PsiElement current = lastEoLComment.getNextSibling();
        boolean stopAtFirstNontrivialLine = node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        boolean containsCustomRegionMarker = JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)lastEoLComment);
        while (!(current == null || !(current instanceof PsiWhiteSpace) || stopAtFirstNontrivialLine && (text = current.getText()).startsWith("\n") && text.indexOf(10, 1) > 0)) {
            if ((current = current.getNextSibling()) == null || current.getNode().getElementType() != nodeElementTypeToCollapse) continue;
            lastEoLComment = current;
            containsCustomRegionMarker |= JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)lastEoLComment);
            current = current.getNextSibling();
        }
        if (lastEoLComment != node.getPsi()) {
            int adjustmentOffset = JavaScriptFoldingBuilderBase.isImportNode(node.getElementType()) ? IMPORT_OFFSET : 0;
            TextRange rangeToFold = new TextRange(node.getStartOffset() + adjustmentOffset, lastEoLComment.getTextOffset() + lastEoLComment.getTextLength());
            if (!containsCustomRegionMarker) {
                JavaScriptFoldingBuilderBase.addDescriptorForRange(node, descriptors, rangeToFold);
            }
            return lastEoLComment.getNode();
        }
        return node;
    }

    private static boolean isImportNode(IElementType type) {
        return type == JSStubElementTypes.IMPORT_STATEMENT || type == ES6ElementTypes.IMPORT_DECLARATION;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == JSTokenTypes.DOC_COMMENT) {
            String text = node.getText();
            StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
            String firstLine = "";
            if (tokenizer.countTokens() > 2) {
                tokenizer.nextToken();
                firstLine = tokenizer.nextToken();
                firstLine = StringUtil.replace((String)firstLine.trim(), (String)"*", (String)"") + " ";
            }
            return "/**" + firstLine + "...*/";
        }
        if (type == JSTokenTypes.C_STYLE_COMMENT) {
            return "/*...*/";
        }
        if (type == JSTokenTypes.END_OF_LINE_COMMENT) {
            return "//...";
        }
        if (JavaScriptFoldingBuilderBase.isImportNode(type)) {
            return "...";
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type) || type instanceof JSClassElementTypeBase || type == JSElementTypes.SWITCH_STATEMENT || type == JSStubElementTypes.PACKAGE_STATEMENT) {
            return this.getBlockPlaceholderText();
        }
        if (type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            JSObjectLiteralExpression objectLiteralExpression = (JSObjectLiteralExpression)node.getPsi(JSObjectLiteralExpression.class);
            if (objectLiteralExpression != null) {
                return this.getObjectPlaceholderText(objectLiteralExpression);
            }
            return this.getBlockPlaceholderText();
        }
        if (type == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            return "[...]";
        }
        if (type == JSElementTypes.XML_LITERAL_EXPRESSION) {
            ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
            return "<" + (child != null ? child.getText() : "xml") + "/>";
        }
        return null;
    }

    protected String getBlockPlaceholderText() {
        return "{...}";
    }

    protected String getObjectPlaceholderText(@NotNull JSObjectLiteralExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "getObjectPlaceholderText"));
        }
        JSProperty[] properties = node.getProperties();
        JSProperty candidate = null;
        for (JSProperty property : properties) {
            String name = property.getName();
            boolean isId = "id".equals(name) || "name".equals(name);
            JSExpression value = property.getValue();
            if ((!(value instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)value)) && (!(value instanceof JSLiteralExpression) || !isId && !((JSLiteralExpression)value).isQuotedLiteral())) continue;
            if (candidate == null || isId) {
                candidate = property;
            }
            if (isId) break;
        }
        if (candidate != null) {
            return this.getFoldedTestByProperty(candidate);
        }
        return this.getBlockPlaceholderText();
    }

    @NotNull
    protected String getFoldedTestByProperty(JSProperty candidate) {
        String string = "{\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...}";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "getFoldedTestByProperty"));
        }
        return string;
    }

    protected abstract JSCodeFoldingSettings getCodeFoldingSettings();

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        IElementType parentElementType;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase", "isRegionCollapsedByDefault"));
        }
        JSCodeFoldingSettings jsCodeFoldingSettings = this.getCodeFoldingSettings();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentElementType = parentNode != null ? parentNode.getElementType() : null;
        if (parentElementType instanceof JSFileElementType && node.getTreePrev() == null && node.getPsi() instanceof PsiComment) {
            return jsCodeFoldingSettings.isCollapseFileHeaders();
        }
        IElementType nodeElementType = node.getElementType();
        if (nodeElementType == JSStubElementTypes.IMPORT_STATEMENT) {
            return jsCodeFoldingSettings.isCollapseImports();
        }
        if (nodeElementType == ES6ElementTypes.IMPORT_DECLARATION) {
            return this.isES6ImportCollapse();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) && (JSElementTypes.FUNCTION_DECLARATIONS.contains(parentElementType) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentElementType))) {
            return jsCodeFoldingSettings.isCollapseMethods();
        }
        if (nodeElementType == JSTokenTypes.DOC_COMMENT) {
            return jsCodeFoldingSettings.isCollapseDocComments();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseObjectLiterals();
        }
        if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseArrayLiterals();
        }
        if (nodeElementType == JSElementTypes.XML_LITERAL_EXPRESSION) {
            return jsCodeFoldingSettings.isCollapseXmlLiterals();
        }
        return false;
    }

    protected boolean isES6ImportCollapse() {
        return this.getCodeFoldingSettings().isCollapseJSImports();
    }

    protected boolean isCustomFoldingCandidate(ASTNode node) {
        return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || node.getPsi() instanceof PsiComment && !node.getText().contains("\n");
    }

    protected boolean isCustomFoldingRoot(ASTNode node) {
        IElementType nodeType = node.getElementType();
        return nodeType == JSStubElementTypes.FILE || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || nodeType == JSElementTypes.EMBEDDED_CONTENT;
    }
}

