/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.amd.JSCommonReferenceContributor;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfigFinder;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSReferenceContributor
implements JSModuleReferenceContributor {
    public static final SystemJSReferenceContributor SYSTEM_JS_REF_CONTRIBUTOR = new SystemJSReferenceContributor();
    private final SystemJSConfigFinder myFinder = new SystemJSConfigFinder();

    @Override
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getCommonJSModuleReferences"));
        }
        Collection<SystemJSConfig> configs = this.myFinder.getConfigs(host);
        if (configs.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getCommonJSModuleReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList refs = ContainerUtil.newArrayList();
        for (SystemJSConfig config : configs) {
            Collection<PsiReference> references = SystemJSReferenceContributor.createReferences(config, unquotedRefText, host, offset, provider);
            if (references.isEmpty()) continue;
            refs.addAll(references);
        }
        if (unquotedRefText.indexOf(33) > 0) {
            ContainerUtil.addAll((Collection)refs, (Object[])new JSCommonReferenceContributor.JSAmdModuleFileReferenceSet(unquotedRefText, host, offset, provider){

                @Override
                public FileReference createFileReference(TextRange textRange, int i, String text) {
                    return new SystemJSModuleReference(text, i, textRange, this, "systemmodule.js", true);
                }
            }.getAllReferences());
        }
        PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[0]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    private static Collection<PsiReference> createReferences(@NotNull SystemJSConfig config, @NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createReferences"));
        }
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createReferences"));
        }
        Collection<SystemJSPathSubstitution> mappings = config.getMappings();
        Pair<SystemJSPathSubstitution, String> matchedElement = JSPathMappingsUtil.findMaxElementByPaths(unquotedRefText, mappings);
        if (matchedElement == null) {
            return ContainerUtil.emptyList();
        }
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        String pattern = matchedPattern.getPattern();
        Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
        Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
        ArrayList refs = ContainerUtil.newArrayList();
        if (!forFileReference.isEmpty()) {
            String patternWithoutStar = JSPathMappingsUtil.getPatternOrMappingWithoutStar(pattern);
            int endExactRef = offset + patternWithoutStar.length();
            TextRange range = TextRange.create((int)offset, (int)endExactRef);
            final SystemJSExactParentFileReference reference = new SystemJSExactParentFileReference(host, range, SystemJSReferenceContributor.convertPaths(config, forFileReference), null);
            refs.add(reference);
            refs.addAll(ContainerUtil.newArrayList((Object[])new FileReferenceSet(matchedStar, host, endExactRef + 1, provider, false, true, DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY){

                public FileReference createFileReference(TextRange range, int index, String text) {
                    return new SystemJSModuleReference(text, index, range, this, "File.js", true);
                }

                @NotNull
                public Collection<PsiFileSystemItem> computeDefaultContexts() {
                    ResolveResult[] results = reference.multiResolve(false);
                    Collection collection = Arrays.stream(results).map(ResolveResult::getElement).filter(el -> el instanceof PsiFileSystemItem).map(el -> (PsiFileSystemItem)el).collect(Collectors.toList());
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$2", "computeDefaultContexts"));
                    }
                    return collection;
                }
            }.getAllReferences()));
        }
        if (!forExactReference.isEmpty()) {
            TextRange range = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
            ArrayList<String> elementsWithReplacedStar = SystemJSReferenceContributor.replaceStarsByMatchedString(matchedStar, forExactReference);
            refs.add(SystemJSReferenceContributor.createExactFileReference(config, host, range, elementsWithReplacedStar));
        }
        return refs;
    }

    @NotNull
    private static JSExactFileReference createExactFileReference(@NotNull SystemJSConfig config, @NotNull PsiElement host, TextRange range, Collection<String> elementsWithReplacedStar) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createExactFileReference"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createExactFileReference"));
        }
        JSExactFileReference jSExactFileReference = new JSExactFileReference(host, range, SystemJSReferenceContributor.convertPaths(config, elementsWithReplacedStar), JSFileReference.IMPLICIT_EXTENSIONS);
        if (jSExactFileReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "createExactFileReference"));
        }
        return jSExactFileReference;
    }

    @NotNull
    private static ArrayList<String> replaceStarsByMatchedString(String matchedStar, Collection<String> forExactReference) {
        ArrayList elementsWithReplacedStar = ContainerUtil.newArrayList();
        for (String mapping : forExactReference) {
            String currentEl = matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
            elementsWithReplacedStar.add(currentEl);
        }
        ArrayList arrayList = elementsWithReplacedStar;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "replaceStarsByMatchedString"));
        }
        return arrayList;
    }

    private static Collection<String> convertPaths(@NotNull SystemJSConfig config, Collection<String> forFileReference) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "convertPaths"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        VirtualFile baseURL = config.getBaseURL();
        VirtualFile root = config.rootDirectory();
        for (String path : forFileReference) {
            String toProcess = JSPathMappingsUtil.getPatternOrMappingWithoutStar(path);
            result.add(JSPathMappingsUtil.getStringPathRelativeBaseUrl(toProcess.startsWith(".") ? root : baseURL, toProcess));
        }
        return result;
    }

    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = this.getCommonJSModuleReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript(host);
    }

    protected static class SystemJSModuleReference
    extends JSModuleReference {
        public SystemJSModuleReference(String text, int offset, TextRange textRange, FileReferenceSet fileReferenceSet, String newFileTemplateName, boolean isSoft) {
            super(text, offset, textRange, fileReferenceSet, newFileTemplateName, isSoft);
        }

        @Override
        protected void innerResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem psiFileSystemItem, Collection<ResolveResult> resolveResults, boolean b) {
            int indexExcl;
            if (referenceText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceText", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$SystemJSModuleReference", "innerResolveInContext"));
            }
            if (psiFileSystemItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFileSystemItem", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$SystemJSModuleReference", "innerResolveInContext"));
            }
            String textToProcess = referenceText;
            if (this.isLast() && (indexExcl = referenceText.indexOf(33)) > 0) {
                textToProcess = referenceText.substring(0, indexExcl);
            }
            super.innerResolveInContext(textToProcess, psiFileSystemItem, resolveResults, b);
        }

        @Override
        protected String fixExtension(String newName) {
            String text = this.getText();
            int indexExcl = text.indexOf(33);
            if (indexExcl > 0) {
                String namePart = text.substring(0, indexExcl);
                String postfixPart = text.substring(indexExcl);
                return this.fixExtension(newName, namePart) + postfixPart;
            }
            return super.fixExtension(newName);
        }
    }

    private static class SystemJSExactParentFileReference
    extends JSExactFileReference
    implements JSParentReference {
        public SystemJSExactParentFileReference(@NotNull PsiElement context, @NotNull TextRange range, @NotNull Collection<String> filePaths, @Nullable String[] extensions) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            if (filePaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSReferenceContributor$SystemJSExactParentFileReference", "<init>"));
            }
            super(context, range, filePaths, extensions);
        }
    }
}

