/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class OverrideMethodsFix
extends BaseCreateMethodsFix<JSFunction> {
    public OverrideMethodsFix(JSClass jsClass) {
        super(jsClass);
    }

    @Override
    protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSFunction func) {
        return OverrideMethodsFix.buildDelegatingText(retType, parameterList, func, "super", (PsiElement)(this.anchor != null ? this.anchor : this.myJsClass));
    }

    public static String buildDelegatingText(String retType, JSParameterList parameterList, JSFunction func, String qualifier, @NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/generation/OverrideMethodsFix", "buildDelegatingText"));
        }
        StringBuilder functionText = new StringBuilder();
        functionText.append("{\n");
        if (!"void".equals(retType)) {
            functionText.append("return ");
        }
        functionText.append(qualifier).append(".");
        JSAttributeList attributeList = func.getAttributeList();
        if (attributeList != null && attributeList.getNamespace() != null) {
            functionText.append(OverrideMethodsFix.calcNamespaceId(attributeList, JSResolveUtil.getNamespaceValue(attributeList), anchor)).append("::");
        }
        functionText.append(func.getName());
        if (!func.isGetProperty()) {
            if (func.isSetProperty()) {
                functionText.append("=").append(parameterList.getParameters()[0].getName());
            } else {
                functionText.append("(");
                boolean first = true;
                for (JSParameterListElement param : parameterList.getParameters()) {
                    if (!first) {
                        functionText.append(",");
                    }
                    first = false;
                    functionText.append(param.getName());
                }
                functionText.append(")");
            }
        }
        functionText.append(JSCodeStyleSettings.getSemicolon(func.getContainingFile())).append("}");
        return functionText.toString();
    }

    @Override
    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSFunction function) {
        super.adjustAttributeList(attributeListWrapper, function);
        if (DialectDetector.isActionScript((PsiElement)this.myJsClass)) {
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.DYNAMIC, false);
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, element instanceof JSClass && !JSResolveUtil.isObjectClass((JSClass)element));
        }
    }
}

