/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.navigation.JavaScriptGotoSuperHandler;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.lang.javascript.search.JSGotoTargetRendererProvider;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.MergeQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptLineMarkerProvider
implements LineMarkerProvider {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;
    public static final Function<PsiElement, String> ourClassInheritorsTooltipProvider = new ConstantFunction((Object)"Has subclasses");
    private static final Function<PsiElement, String> ourImplementedInterfacesTooltipProvider = new ConstantFunction((Object)"Has implementations");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider = new ConstantFunction((Object)"Is overridden");
    private static final Function<PsiElement, String> ourOverriddenFunctionsTooltipProvider2 = new ConstantFunction((Object)"Has subtypes");
    private static final Function<PsiElement, String> ourImplementingFunctionsTooltipProvider = new ConstantFunction((Object)"Is implemented");
    public static final BasicGutterIconNavigationHandler<JSClass> ourClassInheritorsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.subclass", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return JSClassSearch.searchClassInheritors(elt, true);
        }
    };
    public static final BasicGutterIconNavigationHandler<JSClass> ourInterfaceImplementationsNavHandler = new BasicGutterIconNavigationHandler<JSClass>(){

        @Override
        protected String getTitle(JSClass elt, int size) {
            String name = JSFormatUtil.formatClass(elt, 1);
            return JSBundle.message((String)"choose.implementing.class", (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSClass> search(JSClass elt) {
            return new MergeQuery(JSClassSearch.searchClassInheritors(elt, true), JSClassSearch.searchInterfaceImplementations(elt, true));
        }
    };
    private static final BasicGutterIconNavigationHandler<JSPsiElementBase> ourOverriddenFunctionsNavHandler = new BasicGutterIconNavigationHandler<JSPsiElementBase>(){

        @Override
        protected String getTitle(JSPsiElementBase elt, int size) {
            if (elt instanceof JSFunction) {
                boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
                String name = JSFormatUtil.formatMethod((JSFunction)elt, 1, 0);
                return JSBundle.message((String)(ecma ? "choose.overridden.method" : "choose.overridden.function"), (Object[])new Object[]{name, size});
            }
            return JSBundle.message((String)"choose.overridden.function", (Object[])new Object[]{elt.getName(), size});
        }

        @Override
        public Query<JSPsiElementBase> search(JSPsiElementBase elt) {
            return JSResolveUtil.doFindOverridenFunctionStatic(elt);
        }
    };
    private static final BasicGutterIconNavigationHandler<JSFunction> ourImplementingFunctionsNavHandler = new BasicGutterIconNavigationHandler<JSFunction>(){

        @Override
        protected String getTitle(JSFunction elt, int size) {
            boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
            String name = JSFormatUtil.formatMethod(elt, 1, 0);
            return JSBundle.message((String)(ecma ? "choose.implementing.method" : "choose.implementing.function"), (Object[])new Object[]{name, size});
        }

        @Override
        public Query<JSFunction> search(JSFunction elt) {
            return JSFunctionsSearch.searchImplementingFunctions(elt, true);
        }
    };

    public JavaScriptLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    private static PsiElement findPrev(PsiElement element, Class ... classes) {
        PsiElement startFrom = element.getFirstChild();
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev instanceof PsiComment) {
            startFrom = prev;
        }
        if (startFrom != null) {
            PsiElement cur = element.getPrevSibling();
            while (cur != null) {
                cur = cur.getPrevSibling();
                for (Class cls : classes) {
                    if (!cls.isInstance(cur)) continue;
                    return cur;
                }
            }
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createBottomMethodSeparatorLineMarker(@NotNull PsiElement startFrom, @NotNull EditorColorsManager colorsManager) {
        if (startFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFrom", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        if (colorsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsManager", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        LineMarkerInfo info = new LineMarkerInfo(startFrom, startFrom.getTextRange(), null, 4, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
        EditorColorsScheme scheme = colorsManager.getGlobalScheme();
        info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.BOTTOM;
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createBottomMethodSeparatorLineMarker"));
        }
        return lineMarkerInfo;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        JSPsiElementBase namedElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (this.myDaemonSettings.SHOW_METHOD_SEPARATORS) {
            PsiElement prev;
            PsiElement parent;
            if (element instanceof JSFunction && !(element instanceof JSFunctionExpression)) {
                parent = JSResolveUtil.findParent(element);
                if ((parent instanceof JSClass || parent instanceof JSBlockStatement && parent.getParent() instanceof JSFunction || parent instanceof JSFile || parent instanceof JSEmbeddedContent) && (prev = JavaScriptLineMarkerProvider.findPrev(element, JSNamedElement.class, JSVarStatement.class)) != null && (!(prev instanceof TypeScriptFunction) || !((TypeScriptFunction)prev).isOverloadDeclaration())) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSProperty) {
                prev = JavaScriptLineMarkerProvider.findPrev(element, JSProperty.class);
                if (((JSProperty)element).tryGetFunctionInitializer() != null || prev instanceof JSProperty && ((JSProperty)prev).tryGetFunctionInitializer() != null) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(element), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSAssignmentExpression) {
                JSExpression prevAssignmentExpression;
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)element;
                PsiElement elementParent = element.getParent();
                PsiElement prev2 = JavaScriptLineMarkerProvider.findPrev(elementParent, JSExpressionStatement.class);
                if (prev2 instanceof JSExpressionStatement && (assignmentExpression.getROperand() instanceof JSFunctionExpression || (prevAssignmentExpression = ((JSExpressionStatement)prev2).getExpression()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)prevAssignmentExpression).getROperand() instanceof JSFunctionExpression)) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(elementParent), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSVariable) {
                JSExpression initializer = ((JSVariable)element).getInitializer();
                if (initializer instanceof JSFunctionExpression) {
                    return LineMarkersPass.createMethodSeparatorLineMarker((PsiElement)JavaScriptLineMarkerProvider.findElementToStartMethodSeparator(((JSVariable)element).getNameIdentifier()), (EditorColorsManager)this.myColorsManager);
                }
            } else if (element instanceof JSFunctionExpression && (parent = element.getParent()) instanceof JSProperty && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent, JSProperty.class) == null) {
                return JavaScriptLineMarkerProvider.createBottomMethodSeparatorLineMarker(element, this.myColorsManager);
            }
        }
        if ((namedElement = JavaScriptLineMarkerProvider.getElementFromLineMarker(element, false)) instanceof JSFunction && JavaScriptLineMarkerProvider.getPlaceForLineMarker(namedElement) == element) {
            final JSFunction function = (JSFunction)namedElement;
            if (function.getNameIdentifier() == null) {
                return null;
            }
            Ref className = new Ref();
            Ref isInterface = Ref.create((Object)Boolean.FALSE);
            JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)function, true, (function1, s) -> {
                isInterface.set((Object)JSSymbolUtil.isInterface(s, (PsiElement)namedElement));
                className.set(s);
                return false;
            }, true);
            if (!className.isNull()) {
                String tooltip = JSBundle.message((String)((Boolean)isInterface.get() != false ? "linemarker.implements.method.in" : "linemarker.overrides.method.in"), (Object[])new Object[]{className.get()});
                return JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)function, (Boolean)isInterface.get() != false ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<String>(tooltip){

                    public String fun(PsiElement element) {
                        return (String)this.myParam;
                    }
                }, new GutterIconNavigationHandler<PsiElement>(){

                    public void navigate(MouseEvent e, PsiElement place) {
                        JSFunction elt = (JSFunction)JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
                        THashSet results = new THashSet();
                        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)function, true, (arg_0, arg_1) -> 6.lambda$navigate$0((Set)results, arg_0, arg_1), true);
                        String name = JSFormatUtil.formatMethod(elt, 1, 0);
                        boolean ecma = DialectDetector.isActionScript((PsiElement)elt);
                        JavaScriptLineMarkerProvider.doNavigate((Collection)results, JSBundle.message((String)(ecma ? "choose.super.method" : "choose.super.function"), (Object[])new Object[]{name, results.size()}), e);
                    }

                    private static /* synthetic */ Boolean lambda$navigate$0(Set results, List functions, String s) {
                        results.addAll(functions);
                        return true;
                    }
                }, 4);
            }
        }
        return null;
    }

    private static PsiElement findElementToStartMethodSeparator(PsiElement parent) {
        PsiElement deepestFirst = PsiTreeUtil.getDeepestFirst((PsiElement)parent);
        ASTNode commentNode = deepestFirst.getNode();
        if (commentNode != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            return deepestFirst;
        }
        PsiElement leaf = PsiTreeUtil.prevLeaf((PsiElement)deepestFirst);
        PsiElement comment = null;
        while (!(!(leaf instanceof PsiWhiteSpace) && !(leaf instanceof PsiComment) || leaf instanceof PsiComment && (commentNode = (comment = leaf).getNode()) != null && commentNode.getElementType() == JSDocTokenTypes.DOC_COMMENT_START)) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        if (comment != null) {
            return comment;
        }
        return deepestFirst;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, final @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "collectSlowLineMarkers"));
        }
        THashMap jsFunctionsToProcess = new THashMap();
        THashMap jsMethodsToProcess = new THashMap();
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            JSPsiElementBase el = JavaScriptLineMarkerProvider.getElementFromLineMarker(psiElement, false);
            if (el == null) continue;
            if (el instanceof JSFunction) {
                JSFunction function = (JSFunction)el;
                if (this.isNativeFunction(function)) continue;
                JSClass parentClass = JSUtils.getMemberContainingClass((PsiElement)function);
                if (!JSInheritanceUtil.canBeSuperMethod(function) && (!function.isConstructor() || parentClass != null)) continue;
                if (parentClass != null) {
                    Set functions = (Set)jsMethodsToProcess.get(parentClass);
                    if (functions == null) {
                        functions = new THashSet();
                        jsMethodsToProcess.put(parentClass, functions);
                    }
                    functions.add(function);
                    continue;
                }
                PsiElement parent = function.getParent();
                if (!(parent instanceof JSFile) && !(function instanceof JSFunctionExpression)) continue;
                JavaScriptLineMarkerProvider.addJSSymbolToSearch((Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, (JSPsiElementBase)function);
                continue;
            }
            if (el instanceof JSClass) {
                JSClass clazz = (JSClass)el;
                if (jsMethodsToProcess.containsKey(clazz)) continue;
                jsMethodsToProcess.put(clazz, null);
                continue;
            }
            if (!(el instanceof JSDefinitionExpression) && !(el instanceof JSVariable) || !JavaScriptLineMarkerProvider.isExtension((JSElement)el)) continue;
            JavaScriptLineMarkerProvider.addJSSymbolToSearch((Map<String, Set<JSPsiElementBase>>)jsFunctionsToProcess, el);
        }
        for (Map.Entry entry : jsFunctionsToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            final boolean isInterface = JSSymbolUtil.isInterface((String)entry.getKey(), (PsiElement)((Set)entry.getValue()).iterator().next());
            final HashSet processed = new HashSet();
            JSResolveUtil.MyNamespaceProcessor processor = new JSResolveUtil.MyNamespaceProcessor((Set)entry.getValue(), false){

                @Override
                protected boolean doProcess(PsiElement elt) {
                    if (processed.contains(this.function)) {
                        return false;
                    }
                    boolean isClassOverride = JSSymbolUtil.isConstructorSymbol(this.function);
                    result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo(this.function, isInterface ? AllIcons.Gutter.ImplementedMethod : AllIcons.Gutter.OverridenMethod, (Function<? super PsiElement, String>)(isClassOverride && isInterface ? ourImplementedInterfacesTooltipProvider : (isClassOverride ? ourOverriddenFunctionsTooltipProvider2 : (isInterface ? ourImplementingFunctionsTooltipProvider : ourOverriddenFunctionsTooltipProvider))), (GutterIconNavigationHandler<PsiElement>)ourOverriddenFunctionsNavHandler));
                    processed.add(this.function);
                    return false;
                }
            };
            processor.processDescendantsOf((String)entry.getKey(), elements.get(0));
        }
        for (Map.Entry entry : jsMethodsToProcess.entrySet()) {
            ProgressManager.checkCanceled();
            final JSClass clazz = (JSClass)entry.getKey();
            final Set methods = (Set)entry.getValue();
            MergeQuery classQuery = JSClassSearch.searchClassInheritors(clazz, methods != null);
            classQuery.forEach((Processor)new Processor<JSClass>(){
                private boolean addedClassMarker;
                private final Set<JSFunction> methodsClone;
                {
                    this.methodsClone = methods == null || clazz.isInterface() ? null : new THashSet((Collection)methods);
                }

                public boolean process(JSClass jsClass) {
                    if (!(clazz instanceof XmlBackedJSClass || clazz.isInterface() || this.addedClassMarker)) {
                        result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.OverridenMethod, (Function<? super PsiElement, String>)ourClassInheritorsTooltipProvider, (GutterIconNavigationHandler<PsiElement>)ourClassInheritorsNavHandler));
                        this.addedClassMarker = true;
                    }
                    if (this.methodsClone != null) {
                        Iterator<JSFunction> functionIterator = this.methodsClone.iterator();
                        while (functionIterator.hasNext()) {
                            JSFunction function = functionIterator.next();
                            JSFunction byName = jsClass.findFunctionByNameAndKind(function.getName(), function.getKind());
                            if (byName == null || !JSInheritanceUtil.canHaveSuperMethod(byName) || !JSResolveUtil.isRealOverride(byName, JSResolveUtil.getNamespaceValue(function.getAttributeList()), (PsiElement)function)) continue;
                            result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)function, AllIcons.Gutter.OverridenMethod, (Function<? super PsiElement, String>)ourOverriddenFunctionsTooltipProvider, (GutterIconNavigationHandler<PsiElement>)ourOverriddenFunctionsNavHandler));
                            functionIterator.remove();
                        }
                    }
                    return this.methodsClone != null && !this.methodsClone.isEmpty();
                }
            });
            if (clazz.isInterface() && (classQuery = new MergeQuery(JSClassSearch.searchInterfaceImplementations(clazz, false), JSClassSearch.searchClassInheritors(clazz, false))).findFirst() != null) {
                result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)clazz, AllIcons.Gutter.ImplementedMethod, ourImplementedInterfacesTooltipProvider, ourInterfaceImplementationsNavHandler));
            }
            if (methods == null) continue;
            for (JSFunction function : methods) {
                Collection<JSFunction> implementedMethods;
                if (clazz.isInterface()) {
                    Query<JSFunction> query = JSFunctionsSearch.searchImplementingFunctions(function, false);
                    if (query.findFirst() == null) continue;
                    result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)function, AllIcons.Gutter.ImplementedMethod, ourImplementingFunctionsTooltipProvider, ourImplementingFunctionsNavHandler));
                    continue;
                }
                JSAttributeList attributeList = function.getAttributeList();
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || (implementedMethods = JSInheritanceUtil.findImplementedMethods(function)).isEmpty()) continue;
                result.add(JavaScriptLineMarkerProvider.createLineMarkerInfo((JSPsiElementBase)function, AllIcons.Gutter.ImplementingMethod, (Function<? super PsiElement, String>)new ParameterizedFunction<PsiElement>(implementedMethods.size() == 1 ? (PsiElement)ContainerUtil.getFirstItem(implementedMethods) : null){

                    public String fun(PsiElement place) {
                        PsiElement implementedMethodIfOnly = (PsiElement)this.myParam;
                        if (implementedMethodIfOnly != null) {
                            String name;
                            PsiElement element;
                            String in = JSBundle.message((String)"linemarker.implements.invalid", (Object[])new Object[0]);
                            if (implementedMethodIfOnly.isValid() && (element = PsiTreeUtil.getParentOfType((PsiElement)implementedMethodIfOnly, JSClass.class)) != null && (name = ((NavigationItem)element).getName()) != null) {
                                in = name;
                            }
                            return JSBundle.message((String)"linemarker.implements.text", (Object[])new Object[]{JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true).getName(), in});
                        }
                        return JSBundle.message((String)"linemarker.implements.several", (Object[])new Object[0]);
                    }
                }, new GutterIconNavigationHandler<PsiElement>(){

                    public void navigate(MouseEvent e, PsiElement place) {
                        JSFunction elt = (JSFunction)JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
                        Collection<JSFunction> results = JSInheritanceUtil.findImplementedMethods(elt);
                        String name = JSFormatUtil.formatMethod(elt, 1, 0);
                        JavaScriptLineMarkerProvider.doNavigate(results, JSBundle.message((String)"choose.super.method", (Object[])new Object[]{name, results.size()}), e);
                    }
                }));
            }
        }
    }

    public boolean isNativeFunction(JSFunction function) {
        JSAttributeList attrList;
        return function.getContainingFile().getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 && (attrList = function.getAttributeList()) != null && attrList.hasModifier(JSAttributeList.ModifierType.NATIVE);
    }

    @NotNull
    private static PsiElement getPlaceForLineMarker(@NotNull JSPsiElementBase element) {
        PsiElement nameIdentifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
        }
        if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)element)) != element) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
            }
            return psiElement;
        }
        PsiElement child = element.getFirstChild();
        Object object = child != null ? child : element;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getPlaceForLineMarker"));
        }
        return object;
    }

    @Contract(value="_, true -> !null")
    @Nullable
    public static JSPsiElementBase getElementFromLineMarker(@NotNull PsiElement place, boolean withAssertion) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "getElementFromLineMarker"));
        }
        JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(place);
        JSPsiElementBase parent = namedElement instanceof JSPsiElementBase ? (JSPsiElementBase)namedElement : (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)place, JSPsiElementBase.class, (boolean)false);
        JSFunction function = JSPsiImplUtils.getPossibleFunction((PsiElement)parent);
        if (function != null) {
            parent = function;
        }
        if (withAssertion) {
            assert (parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place) : "named element wasn't found for " + parent;
            return parent;
        }
        return parent != null && JavaScriptLineMarkerProvider.getPlaceForLineMarker(parent) == place ? parent : null;
    }

    private static boolean isExtension(JSElement def) {
        JSCallExpression callExpression;
        JSExpression methodExpression;
        JSExpression rOperand = null;
        if (def instanceof JSDefinitionExpression) {
            rOperand = ((JSDefinitionExpression)def).getInitializer();
        } else if (def instanceof JSVariable) {
            rOperand = ((JSVariable)def).getInitializer();
        }
        if (rOperand instanceof JSCallExpression && (methodExpression = (callExpression = (JSCallExpression)rOperand).getMethodExpression()) instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)methodExpression;
            return JSSymbolUtil.isExtendCall(refExpr.getQualifier(), refExpr.getReferenceName(), null);
        }
        return false;
    }

    private static void addJSSymbolToSearch(Map<String, Set<JSPsiElementBase>> jsFunctionsToProcess, JSPsiElementBase function) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(function);
        if (qName != null) {
            THashSet functions = jsFunctionsToProcess.get(qName);
            if (functions == null) {
                functions = new THashSet();
                jsFunctionsToProcess.put(qName, (Set<JSPsiElementBase>)functions);
            }
            functions.add((JSPsiElementBase)function);
        }
    }

    private static void doNavigate(Collection<? extends JSPsiNamedElementBase> items, String popupTitle, MouseEvent e) {
        JSGotoTargetRendererProvider.JSClassListCellRenderer renderer = new JSGotoTargetRendererProvider.JSClassListCellRenderer();
        items = JavaScriptGotoSuperHandler.sort(items, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])items.toArray(new NavigatablePsiElement[items.size()]), (String)popupTitle, null, (ListCellRenderer)((Object)renderer));
    }

    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        if (navHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navHandler", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        return JavaScriptLineMarkerProvider.createLineMarkerInfo(element, icon, tooltipProvider, navHandler, 6);
    }

    private static LineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull JSPsiElementBase element, Icon icon, @Nullable Function<? super PsiElement, String> tooltipProvider, @NotNull GutterIconNavigationHandler<PsiElement> navHandler, int updatePass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        if (navHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navHandler", "com/intellij/lang/javascript/highlighting/JavaScriptLineMarkerProvider", "createLineMarkerInfo"));
        }
        PsiElement place = JavaScriptLineMarkerProvider.getPlaceForLineMarker(element);
        return new LineMarkerInfo(place, place.getTextRange(), icon, updatePass, tooltipProvider, navHandler, GutterIconRenderer.Alignment.RIGHT);
    }

    private static abstract class ParameterizedFunction<P>
    implements Function<PsiElement, String> {
        @Nullable
        protected final P myParam;

        public ParameterizedFunction(@Nullable P param) {
            this.myParam = param;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedFunction)) {
                return false;
            }
            P otherParam = ((ParameterizedFunction)obj).myParam;
            return this.myParam != null ? this.myParam.equals(otherParam) : otherParam == null;
        }

        public int hashCode() {
            return this.myParam != null ? this.myParam.hashCode() : 0;
        }
    }

    public static abstract class BasicGutterIconNavigationHandler<T extends JSPsiNamedElementBase>
    implements GutterIconNavigationHandler<PsiElement> {
        public void navigate(MouseEvent e, PsiElement place) {
            JSPsiElementBase elt = JavaScriptLineMarkerProvider.getElementFromLineMarker(place, true);
            Query<JSPsiElementBase> elementQuery = this.search(elt);
            if (elementQuery == null) {
                return;
            }
            Collection navElements = elementQuery.findAll();
            JavaScriptLineMarkerProvider.doNavigate(navElements, this.getTitle(elt, navElements.size()), e);
        }

        protected abstract String getTitle(T var1, int var2);

        @Nullable
        public abstract Query<T> search(T var1);
    }
}

