/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileCachedDataEvaluator
extends JSElementVisitor {
    @NotNull
    protected final JSFileCachedData myCachedData;
    private Stack<Boolean> mySkipChildren;
    private boolean mySkipCurrentElementChildren;

    public JSFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outCachedData", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "<init>"));
        }
        this.mySkipChildren = ContainerUtil.newStack();
        this.myCachedData = outCachedData;
    }

    public void setSkipChildren() {
        this.mySkipCurrentElementChildren = true;
    }

    public boolean isSkipChildren() {
        return !this.mySkipChildren.isEmpty() && (Boolean)this.mySkipChildren.peek() != false;
    }

    public void startElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "startElement"));
        }
        this.mySkipCurrentElementChildren = this.isSkipChildren();
        if (!this.mySkipCurrentElementChildren) {
            element.accept((PsiElementVisitor)this);
        }
        this.mySkipChildren.push((Object)this.mySkipCurrentElementChildren);
    }

    public void finishElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "finishElement"));
        }
        this.mySkipCurrentElementChildren = (Boolean)this.mySkipChildren.pop();
    }

    public void visitJSCallExpression(JSCallExpression node) {
        JSType type;
        JSExpression moduleInitializer;
        if (node.isRequireCall()) {
            this.myCachedData.setIsCommonJSModule();
        } else if (JSAmdPsiUtil.isDefineCall(node) && (moduleInitializer = JSAmdPsiUtil.getModuleInitializer(node)) instanceof JSFunctionExpression && (type = JSSymbolUtil.evaluateModuleInnerAlias((JSFunction)((JSFunctionExpression)moduleInitializer), "exports")) != null) {
            this.myCachedData.setExportsInnerAlias(type);
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])Extensions.getExtensions(FrameworkIndexingHandler.EP_NAME)) {
            handler.processCallExpression(node, this.myCachedData);
        }
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
        JSExpression lOperand = node.getLOperand();
        if (lOperand instanceof JSDefinitionExpression) {
            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
        }
        if (lOperand instanceof JSReferenceExpression) {
            JSExpression qualifier;
            if (JSSymbolUtil.isExportReference((JSReferenceExpression)lOperand)) {
                JSType type;
                this.myCachedData.setIsCommonJSModule();
                JSExpression rOperand = node.getROperand();
                if (rOperand != null && (type = JSFileCachedDataEvaluator.getExportsInnerAliasType(rOperand)) != null) {
                    this.myCachedData.setExportsInnerAlias(type);
                }
            }
            if ((qualifier = ((JSReferenceExpression)lOperand).getQualifier()) instanceof JSReferenceExpression && JSSymbolUtil.isExportReference((JSReferenceExpression)qualifier)) {
                this.myCachedData.setIsCommonJSModule();
            }
        }
    }

    @Nullable
    private static JSType getExportsInnerAliasType(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/index/JSFileCachedDataEvaluator", "getExportsInnerAliasType"));
        }
        if (expression instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)expression).getExpression();
        }
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSAssignmentExpression) {
            JSType rType;
            JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
            JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
            JSType lType = lOperand != null ? JSFileCachedDataEvaluator.getExportsInnerAliasType(lOperand) : null;
            JSType jSType = rType = rOperand != null ? JSFileCachedDataEvaluator.getExportsInnerAliasType(rOperand) : null;
            if (lType == null) {
                return rType;
            }
            if (rType == null) {
                return lType;
            }
            return JSCompositeTypeImpl.getCommonType(lType, rType, null, false);
        }
        if (expression instanceof JSReferenceExpression) {
            JSType type;
            JSNamespaceEvaluationResult namespace = JSSymbolUtil.evaluateNamespaceLocallyAsIs(expression);
            JSType jSType = type = namespace != null ? namespace.toType((PsiElement)expression) : null;
            if (type instanceof JSNamedType) {
                return JSTypeUtils.copyWithNewSourceRecursive(type, JSTypeSource.EMPTY);
            }
        } else if (expression instanceof JSFunctionExpression) {
            JSType type = JSSymbolUtil.evaluateReturnedTypeLocally((JSFunction)((JSFunctionExpression)expression));
            if (type instanceof JSNamedType) {
                type = JSTypeUtils.copyWithNewSourceRecursive(type, JSTypeSource.EMPTY);
                return new JSFunctionTypeImpl(JSTypeSource.EMPTY, Collections.emptyList(), type);
            }
        } else if (expression instanceof JSCallExpression && ((JSCallExpression)expression).isRequireCall()) {
            String path = CommonJSUtil.getRequireCallModulePath((JSCallExpression)expression);
            if (path != null) {
                return new JSRequireCallExpressionType(path, JSTypeSource.EMPTY);
            }
        } else {
            JSNamespaceEvaluationResult result = JSSymbolUtil.evaluateNamespaceLocally(expression);
            if (result != null) {
                return result.toType((PsiElement)expression);
            }
        }
        return null;
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (JSSymbolUtil.isExplicitExportReference((JSExpression)node)) {
            this.tryAddExportsAliasFromAnonymousFunctionCall(node);
        }
        super.visitJSReferenceExpression(node);
    }

    private void tryAddExportsAliasFromAnonymousFunctionCall(JSReferenceExpression node) {
        JSExpression[] arguments;
        PsiElement argumentList = node.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return;
        }
        PsiElement callExpression = argumentList.getParent();
        if (!(callExpression instanceof JSCallExpression)) {
            return;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)methodExpression).getQualifier() != null) {
            return;
        }
        JSFunction function = JSPsiImplUtils.getScopeFunction((JSElement)methodExpression);
        if (!(function instanceof JSFunctionExpression)) {
            return;
        }
        PsiElement resolvedElement = JSResolveUtil.getLocalVariableRef(function, (JSReferenceExpression)methodExpression);
        if (!(resolvedElement instanceof JSParameter) || ((JSParameter)resolvedElement).getDeclaringFunction() != function) {
            return;
        }
        JSCallExpression call = JSSymbolUtil.getAnonymousFunCall(function);
        if (call == null) {
            return;
        }
        int factoryParameterIndex = JSUtils.findParameterIndex(function, (JSParameter)resolvedElement);
        if (factoryParameterIndex >= (arguments = call.getArguments()).length) {
            return;
        }
        JSExpression factory = arguments[factoryParameterIndex];
        if (!(factory instanceof JSFunctionExpression)) {
            return;
        }
        int exportsIndex = ArrayUtil.indexOf((Object[])((JSCallExpression)callExpression).getArguments(), (Object)node);
        assert (exportsIndex >= 0) : "reference wasn't found in " + callExpression.getText();
        JSParameter[] factoryParameters = ((JSFunctionExpression)factory).getParameterVariables();
        if (exportsIndex >= factoryParameters.length) {
            return;
        }
        JSParameter exportsParameter = factoryParameters[exportsIndex];
        String name = exportsParameter.getName();
        if (name == null) {
            return;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)exportsParameter);
        this.myCachedData.setExportsInnerAlias(JSNamedType.createType(name, typeSource, JSTypeContext.STATIC));
    }
}

