/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileIncludeProvider
extends FileIncludeProvider {
    private static final String START_PREFIX = "./";

    @NotNull
    public String getId() {
        String string = TypeScriptFileType.INSTANCE.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getId"));
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType()) && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(file);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
            fileTypeSink.consume((Object)type);
        }
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)content.getPsiFile(), JSFile.class);
        if (file == null) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        FileIncludeInfo[] fileIncludeInfoArray = TypeScriptFileIncludeProvider.buildFileIncludeInfo(file.getReferencedPaths());
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }

    @NotNull
    private static FileIncludeInfo[] buildFileIncludeInfo(Collection<String> refSet) {
        if (refSet.isEmpty()) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "buildFileIncludeInfo"));
            }
            return FileIncludeInfo.EMPTY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (String ref : refSet) {
            boolean addSuffix;
            String path = FileUtil.toSystemIndependentName((String)StringUtil.unquoteString((String)ref));
            boolean addPrefix = TypeScriptFileIncludeProvider.needPrefix(path);
            boolean bl = addSuffix = JSFileReference.findExtension(path, TypeScriptUtil.TYPESCRIPT_EXTENSIONS) == null;
            if (!addSuffix) {
                result.add(TypeScriptFileIncludeProvider.createInfo(addPrefix ? START_PREFIX + path : path));
                continue;
            }
            result.add(TypeScriptFileIncludeProvider.createInfo(addPrefix ? START_PREFIX + path + ".ts" : path + ".ts"));
            result.add(TypeScriptFileIncludeProvider.createInfo(addPrefix ? START_PREFIX + path + ".d.ts" : path + ".d.ts"));
            result.add(TypeScriptFileIncludeProvider.createInfo(addPrefix ? START_PREFIX + path + ".tsx" : path + ".tsx"));
        }
        FileIncludeInfo[] fileIncludeInfoArray = result.toArray(new FileIncludeInfo[0]);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "buildFileIncludeInfo"));
        }
        return fileIncludeInfoArray;
    }

    private static FileIncludeInfo createInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/index/TypeScriptFileIncludeProvider", "createInfo"));
        }
        return new FileIncludeInfo(path);
    }

    private static boolean needPrefix(String path) {
        return !path.startsWith(START_PREFIX) && !path.startsWith("../") && !FileUtil.isAbsolutePlatformIndependent((String)path);
    }

    public int getVersion() {
        return 2;
    }
}

