/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inject;

import com.intellij.lang.Language;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.inject.JSRegexpLanguage;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpParserDefinition;
import org.intellij.lang.regexp.RegExpTT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexpParserDefinition
extends RegExpParserDefinition {
    public static final IFileElementType JS_REGEXP_FILE = new IFileElementType("JS_REGEXP_FILE", (Language)JSRegexpLanguage.INSTANCE);
    private final EnumSet<RegExpCapability> CAPABILITIES = EnumSet.of(RegExpCapability.OCTAL_NO_LEADING_ZERO, RegExpCapability.DANGLING_METACHARACTERS, RegExpCapability.ALLOW_EMPTY_CHARACTER_CLASS);

    @NotNull
    public Lexer createLexer(Project project) {
        DelegateLexer delegateLexer = new DelegateLexer((Lexer)new RegExpLexer(this.CAPABILITIES)){

            @Nullable
            public IElementType getTokenType() {
                IElementType baseType = super.getTokenType();
                if (baseType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
                    return RegExpTT.CHAR_CLASS;
                }
                return baseType;
            }
        };
        if (delegateLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inject/JSRegexpParserDefinition", "createLexer"));
        }
        return delegateLexer;
    }

    public PsiParser createParser(Project project) {
        return new RegExpParser(this.CAPABILITIES);
    }

    public IFileElementType getFileNodeType() {
        return JS_REGEXP_FILE;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, (Language)JSRegexpLanguage.INSTANCE);
    }
}

