/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AnonymousToNamedFunctionIntention
extends JavaScriptIntention {
    private String myFunctionName = null;

    public AnonymousToNamedFunctionIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.named.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        return AnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element) != null;
    }

    public static JSFunctionExpression getWrappingAnonymousFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "getWrappingAnonymousFunction"));
        }
        JSFunctionExpression functionExpression = AnonymousToNamedFunctionIntention.getFunctionExpression(element);
        if (functionExpression == null) {
            return null;
        }
        ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(functionExpression.getNode(), true);
        return nameNode == null ? functionExpression : null;
    }

    public static JSFunctionExpression getFunctionExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "getFunctionExpression"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile) && PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class) == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionExpression) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSFunction parent;
        String parameters;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "invoke"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(containingFile)) {
            return;
        }
        this.myFunctionName = null;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myFunctionName = "foo";
        } else {
            new GetFunctionNameDialog(containingFile).show();
        }
        if (this.myFunctionName == null) {
            return;
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class);
        PsiElement returnTypeElement = functionExpression.getReturnTypeElement();
        boolean isArrowFunction = JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) != null;
        String string = parameters = isArrowFunction ? functionExpression.getParameterList().getText() : "()";
        if (!parameters.startsWith("(")) {
            parameters = "(" + parameters + ")";
        }
        String functionText = returnTypeElement == null ? "function " + this.myFunctionName + parameters + " {}" : "function " + this.myFunctionName + parameters + ": " + returnTypeElement.getText() + " {}";
        JSFunction function = (JSFunction)JSChangeUtil.createJSTreeFromText(project, functionText, JSUtils.getDialect(containingFile)).getPsi(JSFunction.class);
        if (!isArrowFunction) {
            function.getParameterList().replace((PsiElement)functionExpression.getParameterList());
        }
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSBlockStatement.class);
        JSBlockStatement functionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (functionExpressionBody == null) {
            JSExpression arrowFunctionBody = (JSExpression)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSExpression.class);
            String bodyText = isArrowFunction && arrowFunctionBody != null ? "{\nreturn " + arrowFunctionBody.getText() + ";\n}" : "{}";
            functionExpressionBody = (JSBlockStatement)JSChangeUtil.createJSTreeFromText(project, bodyText, null).getPsi(JSBlockStatement.class);
        }
        JSChangeUtil.replaceStatement((JSStatement)functionBody, (JSStatement)functionExpressionBody);
        JSSourceElement anchor = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)functionExpression, (Class[])new Class[]{JSFunction.class, JSStatement.class});
        if (anchor != null) {
            parent = anchor.getParent();
            function = (JSFunction)anchor.getParent().addAfter((PsiElement)function, (PsiElement)anchor);
        } else {
            parent = function;
            function = (JSFunction)containingFile.add((PsiElement)function);
        }
        JSChangeUtil.addWs(parent.getNode(), function.getNode(), "\n");
        JSExpression referenceExpression = (JSExpression)JSChangeUtil.createExpressionFromText(project, function.getName()).getPsi(JSReferenceExpression.class);
        referenceExpression = JSChangeUtil.replaceExpression((JSExpression)functionExpression, referenceExpression);
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)referenceExpression.getContainingFile(), referenceExpression.getTextRange().getStartOffset(), function.getTextRange().getEndOffset());
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.anonymous.to.named.function", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/AnonymousToNamedFunctionIntention", "getFamilyName"));
        }
        return string;
    }

    private class GetFunctionNameDialog
    extends DialogWrapper {
        private final JTextField myTextField;
        private final PsiFile myPsiFile;

        protected GetFunctionNameDialog(PsiFile file) {
            super(file.getProject());
            this.myTextField = new JTextField();
            this.myPsiFile = file;
            this.setTitle(StringUtil.capitalizeWords((String)AnonymousToNamedFunctionIntention.this.getText(), (boolean)true));
            this.updateOkAction();
            this.init();
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(7, 2, 5, 2));
            JLabel label = new JLabel("Function name:");
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            panel.add((Component)label, "First");
            label.setLabelFor(this.myTextField);
            panel.add((Component)this.myTextField, "Last");
            this.myTextField.setPreferredSize(new Dimension(200, this.myTextField.getPreferredSize().height));
            this.myTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    GetFunctionNameDialog.this.updateOkAction();
                }
            });
            return panel;
        }

        private void updateOkAction() {
            String text = this.myTextField.getText();
            this.getOKAction().setEnabled(text.length() > 0 && this.isNameValid(text));
        }

        private boolean isNameValid(String text) {
            return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(this.myPsiFile.getLanguage())).isIdentifier(text, this.myPsiFile.getProject());
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTextField;
        }

        protected void doOKAction() {
            AnonymousToNamedFunctionIntention.this.myFunctionName = this.myTextField.getText();
            super.doOKAction();
        }
    }
}

